/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.apache.commons.io.output.ByteArrayOutputStream;

public final class Base64Decoder {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private byte[] token = new byte[4];
    private byte[] bytes = new byte[3];
    private int token_length = 0;
    private static final byte NUL = 127;
    private static final byte EOF = 126;
    private static final byte SP = 125;
    private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 125, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

    private void decode_token() {
        int num = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
        this.bytes[0] = (byte)(0xFF & num >> 16);
        this.bytes[1] = (byte)(0xFF & num >> 8);
        this.bytes[2] = (byte)(0xFF & num);
        this.out.write(this.bytes, 0, 3);
    }

    private void decode_final_token() {
        byte b0 = this.token[0];
        byte b1 = this.token[1];
        byte b2 = this.token[2];
        byte b3 = this.token[3];
        int eq_count = 0;
        if (b0 == 126) {
            b0 = 0;
            ++eq_count;
        }
        if (b1 == 126) {
            b1 = 0;
            ++eq_count;
        }
        if (b2 == 126) {
            b2 = 0;
            ++eq_count;
        }
        if (b3 == 126) {
            b3 = 0;
            ++eq_count;
        }
        if (eq_count > 2) {
            throw new IllegalArgumentException("The number of '=' signs at the end of a base64 value must not exceed 2");
        }
        if (eq_count == 2 && (b1 & 0xF) != 0) {
            throw new IllegalArgumentException("In base64, if the value ends with '==' then the last character must be one of [AQgw]");
        }
        if (eq_count == 1 && (b2 & 3) != 0) {
            throw new IllegalArgumentException("In base64, if the value ends with '=' then the last character must be one of [AEIMQUYcgkosw048]");
        }
        int num = b0 << 18 | b1 << 12 | b2 << 6 | b3;
        this.out.write((int)((byte)(num >> 16)));
        if (eq_count <= 1) {
            this.out.write((int)((byte)(num >> 8 & 0xFF)));
            if (eq_count == 0) {
                this.out.write((int)((byte)(num & 0xFF)));
            }
        }
    }

    public final void translate(CharSequence str) throws IllegalArgumentException {
        if (this.token == null) {
            return;
        }
        int length = str.length();
        int found_eq = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("non-ASCII character in Base64 value (at offset " + i + ')');
            }
            byte t = map[c];
            if (t == 127) {
                throw new IllegalArgumentException("invalid character '" + c + "' in Base64 value (at offset " + i + ')');
            }
            if (found_eq > 0 && t != 126 && t != 125) {
                throw new IllegalArgumentException("In Base64, an '=' character can appear only at the end");
            }
            if (t == 126) {
                if (found_eq > 0) {
                    if (++found_eq > 2) {
                        throw new IllegalArgumentException("Base64 value can contain at most two '=' characters");
                    }
                    this.token_length = (this.token_length + 1) % 4;
                    continue;
                }
                found_eq = 1;
                int lengthAtEOF = this.token_length;
                this.eof();
                this.token_length = (lengthAtEOF + 1) % 4;
                continue;
            }
            if (t == 125) continue;
            this.token[this.token_length++] = t;
            if (this.token_length != 4) continue;
            if (found_eq == 0) {
                this.decode_token();
            }
            this.token_length = 0;
        }
        if (this.token_length != 0) {
            throw new IllegalArgumentException("Base64 input must be a multiple of four characters");
        }
    }

    private void eof() {
        if (this.token != null && this.token_length != 0) {
            while (this.token_length < 4) {
                this.token[this.token_length++] = 126;
            }
            this.decode_final_token();
        }
        this.token_length = 0;
        this.token = new byte[4];
        this.bytes = new byte[3];
    }

    public byte[] getByteArray() {
        this.eof();
        return this.out.toByteArray();
    }

    public void reset() {
        this.out.reset();
    }
}

