/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;

public class Collations {
    private static final Logger logger = LogManager.getLogger(Collations.class);
    public static final String UNICODE_CODEPOINT_COLLATION_URI = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    public static final String CODEPOINT_SHORT = "codepoint";
    public static final String UCA_COLLATION_URI = "http://www.w3.org/2013/collation/UCA";
    public static final String HTML_ASCII_CASE_INSENSITIVE_COLLATION_URI = "http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive";
    public static final String EXIST_COLLATION_URI = "http://exist-db.org/collation";
    private static final AtomicReference<Collator> htmlAsciiCaseInsensitiveCollator = new AtomicReference();
    private static final AtomicReference<Collator> samiskCollator = new AtomicReference();

    @Nullable
    public static Collator getCollationFromURI(String uri) throws XPathException {
        if (uri.startsWith(EXIST_COLLATION_URI) || uri.startsWith(UCA_COLLATION_URI) || uri.startsWith("?")) {
            URI u;
            try {
                u = new URI(uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
            String query = u.getQuery();
            if (query == null) {
                return Collator.getInstance();
            }
            boolean fallback = true;
            String lang = null;
            String version = null;
            String strength = null;
            String maxVariable = "punct";
            String alternate = "non-ignorable";
            boolean backwards = false;
            boolean normalization = false;
            boolean caseLevel = false;
            String caseFirst = null;
            boolean numeric = false;
            String reorder = null;
            String decomposition = null;
            StringTokenizer queryTokenizer = new StringTokenizer(query, ";&");
            block36: while (queryTokenizer.hasMoreElements()) {
                String kw;
                String param = queryTokenizer.nextToken();
                int eq = param.indexOf(61);
                if (eq <= 0 || (kw = param.substring(0, eq)) == null) continue;
                String val = param.substring(eq + 1);
                switch (kw) {
                    case "fallback": {
                        fallback = "yes".equals(val);
                        continue block36;
                    }
                    case "lang": {
                        lang = val;
                        continue block36;
                    }
                    case "version": {
                        version = val;
                        continue block36;
                    }
                    case "strength": {
                        strength = val;
                        continue block36;
                    }
                    case "maxVariable": {
                        maxVariable = val;
                        continue block36;
                    }
                    case "alternate": {
                        alternate = val;
                        continue block36;
                    }
                    case "backwards": {
                        backwards = "yes".equals(val);
                        continue block36;
                    }
                    case "normalization": {
                        normalization = "yes".equals(val);
                        continue block36;
                    }
                    case "caseLevel": {
                        caseLevel = "yes".equals(val);
                        continue block36;
                    }
                    case "caseFirst": {
                        caseFirst = val;
                        continue block36;
                    }
                    case "numeric": {
                        numeric = "yes".equals(val);
                        continue block36;
                    }
                    case "reorder": {
                        reorder = val;
                        continue block36;
                    }
                    case "decomposition": {
                        decomposition = val;
                        continue block36;
                    }
                }
                logger.warn("Unrecognized Collation parameter: " + kw);
            }
            return Collations.getCollationFromParams(fallback, lang, version, strength, maxVariable, alternate, backwards, normalization, caseLevel, caseFirst, numeric, reorder, decomposition);
        }
        if (HTML_ASCII_CASE_INSENSITIVE_COLLATION_URI.equals(uri)) {
            try {
                return Collations.getHtmlAsciiCaseInsensitiveCollator();
            }
            catch (Exception e) {
                throw new XPathException("Unable to instantiate HTML ASCII Case Insensitive Collator: " + e.getMessage(), (Throwable)e);
            }
        }
        if (uri.startsWith("java:")) {
            String uriClassName = uri.substring("java:".length());
            try {
                Class<?> collatorClass = Class.forName(uriClassName);
                if (!Collator.class.isAssignableFrom(collatorClass)) {
                    String msg = "The specified collator class '" + collatorClass.getName() + "' is not a subclass of com.ibm.icu.text.Collator";
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
                return (Collator)collatorClass.newInstance();
            }
            catch (Exception e) {
                String msg = "The specified collator class " + uriClassName + " could not be found";
                logger.error(msg);
                throw new XPathException(ErrorCodes.FOCH0002, msg, (Throwable)e);
            }
        }
        if (UNICODE_CODEPOINT_COLLATION_URI.equals(uri)) {
            return null;
        }
        String msg = "Unknown collation : '" + uri + "'";
        logger.error(msg);
        throw new XPathException(ErrorCodes.FOCH0002, msg);
    }

    public static boolean equals(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.equals(s2);
        }
        return collator.equals(s1, s2);
    }

    public static int compare(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1 == null ? (s2 == null ? 0 : -1) : s1.compareTo(s2);
        }
        return collator.compare(s1, s2);
    }

    public static boolean startsWith(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.startsWith(s2);
        }
        StringSearch searchIterator = new StringSearch(s2, (CharacterIterator)new StringCharacterIterator(s1), (RuleBasedCollator)collator);
        return searchIterator.first() == 0;
    }

    public static boolean endsWith(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.endsWith(s2);
        }
        StringSearch searchIterator = new StringSearch(s2, (CharacterIterator)new StringCharacterIterator(s1), (RuleBasedCollator)collator);
        int lastPos = -1;
        int lastLen = 0;
        int pos = searchIterator.first();
        while (pos != -1) {
            lastPos = pos;
            lastLen = searchIterator.getMatchLength();
            pos = searchIterator.next();
        }
        return lastPos > -1 && lastPos + lastLen == s1.length();
    }

    public static boolean contains(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.contains(s2);
        }
        StringSearch searchIterator = new StringSearch(s2, (CharacterIterator)new StringCharacterIterator(s1), (RuleBasedCollator)collator);
        return searchIterator.first() >= 0;
    }

    public static int indexOf(@Nullable Collator collator, String s1, String s2) {
        if (collator == null) {
            return s1.indexOf(s2);
        }
        StringSearch searchIterator = new StringSearch(s2, (CharacterIterator)new StringCharacterIterator(s1), (RuleBasedCollator)collator);
        return searchIterator.first();
    }

    @Nullable
    private static Collator getCollationFromParams(boolean fallback, @Nullable String lang, @Nullable String version, @Nullable String strength, String maxVariable, String alternate, boolean backwards, boolean normalization, boolean caseLevel, @Nullable String caseFirst, boolean numeric, @Nullable String reorder, @Nullable String decomposition) throws XPathException {
        String[] reorderCodes;
        List icuCollatorReorderCodes;
        Collator collator;
        if ("sme-SE".equals(lang)) {
            try {
                collator = Collations.getSamiskCollator();
            }
            catch (Exception pe) {
                logger.error(pe.getMessage(), (Throwable)pe);
                return null;
            }
        } else {
            ULocale locale = Collations.getLocale(lang);
            collator = Collator.getInstance((ULocale)locale);
        }
        if (!fallback) {
            logger.warn("eXist-db does not yet support disabling collation fallback");
        }
        if (version != null) {
            Object versionInfo;
            try {
                versionInfo = VersionInfo.getInstance((String)version);
            }
            catch (IllegalArgumentException iae) {
                logger.error(iae.getMessage(), (Throwable)iae);
                throw new XPathException(iae.getMessage(), (Throwable)iae);
            }
            if (collator.getVersion().compareTo((VersionInfo)versionInfo) < 0) {
                throw new XPathException("Requested UCA Collation version: " + version + ", however eXist-db only has ICU UCA: " + collator.getVersion().toString());
            }
        }
        if (strength != null) {
            switch (strength) {
                case "identical": {
                    collator.setStrength(15);
                    break;
                }
                case "1": 
                case "primary": {
                    collator.setStrength(0);
                    break;
                }
                case "2": 
                case "secondary": {
                    collator.setStrength(1);
                    break;
                }
                case "3": 
                case "tertiary": {
                    collator.setStrength(2);
                    break;
                }
                case "4": 
                case "quaternary": {
                    collator.setStrength(3);
                    break;
                }
                default: {
                    String msg = "eXist-db only supports Collation strengths of 'identical', 'primary', 'secondary', 'tertiary' or 'quaternary', requested: " + strength;
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
            }
        }
        if (maxVariable != null) {
            switch (maxVariable) {
                case "space": {
                    collator.setMaxVariable(4096);
                    break;
                }
                case "punct": {
                    collator.setMaxVariable(4097);
                    break;
                }
                case "symbol": {
                    collator.setMaxVariable(4098);
                    break;
                }
                case "currency": {
                    collator.setMaxVariable(4099);
                    break;
                }
                default: {
                    String msg = "eXist-db only supports Collation maxVariables of 'space', 'punct', 'symbol', or 'currency', requested: " + maxVariable;
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
            }
        }
        if (alternate != null) {
            switch (alternate) {
                case "non-ignorable": {
                    ((RuleBasedCollator)collator).setAlternateHandlingShifted(false);
                    break;
                }
                case "shifted": 
                case "blanked": {
                    ((RuleBasedCollator)collator).setAlternateHandlingShifted(true);
                    break;
                }
                default: {
                    String msg = "Collation alternate should be either 'non-ignorable', 'shifted' or 'blanked', but received: " + caseFirst;
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
            }
        }
        if (backwards) {
            ((RuleBasedCollator)collator).setFrenchCollation(true);
        }
        if (normalization) {
            collator.setDecomposition(17);
        } else {
            collator.setDecomposition(16);
        }
        if (caseLevel && collator.getStrength() == 0) {
            ((RuleBasedCollator)collator).setCaseLevel(true);
        }
        if (caseFirst != null) {
            switch (caseFirst) {
                case "upper": {
                    ((RuleBasedCollator)collator).setUpperCaseFirst(true);
                    break;
                }
                case "lower": {
                    ((RuleBasedCollator)collator).setLowerCaseFirst(true);
                    break;
                }
                default: {
                    String msg = "Collation case first should be either 'upper' or 'lower', but received: " + caseFirst;
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
            }
        }
        if (numeric) {
            ((RuleBasedCollator)collator).setNumericCollation(true);
        }
        if (reorder != null && !(icuCollatorReorderCodes = Arrays.stream(reorderCodes = reorder.split(",")).map(Collations::toICUCollatorReorderCode).filter(i -> i > -1).collect(Collectors.toList())).isEmpty()) {
            int[] codes = new int[icuCollatorReorderCodes.size()];
            for (int i2 = 0; i2 < codes.length; ++i2) {
                codes[i2] = (Integer)icuCollatorReorderCodes.get(i2);
            }
            collator.setReorderCodes(codes);
        }
        if (decomposition != null) {
            switch (decomposition) {
                case "none": {
                    collator.setDecomposition(16);
                    break;
                }
                case "full": {
                    collator.setDecomposition(15);
                    break;
                }
                case "standard": 
                case "": {
                    collator.setDecomposition(17);
                    break;
                }
                default: {
                    String msg = "Collation decomposition should be either 'none', 'full' or 'standard', but received: " + decomposition;
                    logger.error(msg);
                    throw new XPathException(ErrorCodes.FOCH0002, msg);
                }
            }
        }
        return collator;
    }

    private static int toICUCollatorReorderCode(String reorderCode) {
        switch (reorderCode.toLowerCase()) {
            case "default": {
                return -1;
            }
            case "none": {
                return 103;
            }
            case "others": {
                return 103;
            }
            case "space": {
                return 4096;
            }
            case "first": {
                return 4096;
            }
            case "punctuation": {
                return 4097;
            }
            case "symbol": {
                return 4098;
            }
            case "currency": {
                return 4099;
            }
            case "digit": {
                return 4100;
            }
        }
        logger.warn("eXist-db does not support the collation reorderCode: " + reorderCode);
        return -1;
    }

    private static ULocale getLocale(@Nullable String lang) throws XPathException {
        if (lang == null) {
            return ULocale.getDefault();
        }
        String[] components = lang.split("-");
        switch (components.length) {
            case 3: {
                return new ULocale(components[0], components[1], components[2]);
            }
            case 2: {
                return new ULocale(components[0], components[1]);
            }
            case 1: {
                return new ULocale(components[0]);
            }
        }
        throw new XPathException(ErrorCodes.FOCH0002, "Unrecognized lang=" + lang);
    }

    private static Collator getSamiskCollator() throws Exception {
        Collator collator = samiskCollator.get();
        if (collator == null) {
            samiskCollator.compareAndSet(null, new RuleBasedCollator("< a,A< \u00e1,\u00c1< b,B< c,C< \u010d,\u010c< d,D< \u0111,\u0110< e,E< f,F< g,G< h,H< i,I< j,J< k,K< l,L< m,M< n,N< \u014b,\u014a< o,O< p,P< r,R< s,S< \u0161,\u0160< t,T< \u0167,\u0166< u,U< v,V< z,Z< \u017e,\u017d").freeze());
            collator = samiskCollator.get();
        }
        return collator;
    }

    private static Collator getHtmlAsciiCaseInsensitiveCollator() throws Exception {
        Collator collator = htmlAsciiCaseInsensitiveCollator.get();
        if (collator == null) {
            collator = new RuleBasedCollator("&a=A &b=B &c=C &d=D &e=E &f=F &g=G &h=H &i=I &j=J &k=K &l=L &m=M &n=N &o=O &p=P &q=Q &r=R &s=S &t=T &u=U &v=V &w=W &x=X &y=Y &z=Z");
            collator.setStrength(0);
            htmlAsciiCaseInsensitiveCollator.compareAndSet(null, collator.freeze());
            collator = htmlAsciiCaseInsensitiveCollator.get();
        }
        return collator;
    }
}

