/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.exist.util.FileUtils;
import org.exist.util.SelectorUtils;

public class DirectoryScanner {
    private static final String extractBaseDir(String pattern) {
        int p = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == File.separatorChar || ch == ':') {
                p = i;
                continue;
            }
            if (ch != '*' && ch != '?' || p <= 0) continue;
            return pattern.substring(0, p + 1);
        }
        return null;
    }

    public static final List<Path> scanDir(String pattern) throws IOException {
        String baseDir = DirectoryScanner.extractBaseDir(pattern = pattern.replace('/', File.separatorChar).replace('\\', File.separatorChar));
        if (baseDir == null) {
            baseDir = System.getProperty("user.dir");
            pattern = baseDir + File.separator + pattern;
        }
        Path base = Paths.get(baseDir, new String[0]).normalize();
        return DirectoryScanner.scanDir(base, pattern.substring(baseDir.length()));
    }

    public static final List<Path> scanDir(Path baseDir, String pattern) throws IOException {
        pattern = pattern.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        ArrayList<Path> list = new ArrayList<Path>();
        DirectoryScanner.scanDir(list, baseDir, "", pattern);
        return list;
    }

    private static final void scanDir(List<Path> list, Path dir, String vpath, String pattern) throws IOException {
        List<Path> files = FileUtils.list(dir);
        for (Path file : files) {
            String name = vpath + FileUtils.fileName(file);
            if (Files.isDirectory(file, new LinkOption[0]) && DirectoryScanner.matchStart(pattern, name)) {
                DirectoryScanner.scanDir(list, file, name + File.separator, pattern);
                continue;
            }
            if (!DirectoryScanner.match(pattern, name)) continue;
            list.add(file);
        }
    }

    public static final boolean match(String pattern, String name) {
        return SelectorUtils.matchPath(pattern, name);
    }

    public static final boolean matchStart(String pattern, String name) {
        return SelectorUtils.matchPatternStart(pattern, name);
    }

    public static void main(String[] args) throws IOException {
        List<Path> files = DirectoryScanner.scanDir("/home/*/xml/**/*.xml");
        for (Path file : files) {
            System.out.println(file.toAbsolutePath().toString());
        }
        files = DirectoryScanner.scanDir("/does-not-exist/*.xml");
        for (Path file : files) {
            System.out.println(file.toAbsolutePath().toString());
        }
    }
}

