/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.nio.ByteBuffer;
import org.exist.util.ByteArray;

public class FastByteBuffer
implements ByteArray {
    static boolean DEBUG_FORCE_FIXED_CHUNKSIZE = true;
    static final int DEBUG_FORCE_INIT_BITS = 0;
    byte[][] m_array;
    int m_chunkBits = 15;
    int m_chunkMask;
    int m_chunkSize;
    int m_firstFree = 0;
    FastByteBuffer m_innerFSB = null;
    int m_lastChunk = 0;
    int m_maxChunkBits = 15;
    int m_rebundleBits = 2;

    public FastByteBuffer(int initChunkBits, int maxChunkBits, int rebundleBits) {
        if (DEBUG_FORCE_FIXED_CHUNKSIZE) {
            maxChunkBits = initChunkBits;
        }
        this.m_array = new byte[16][];
        if (initChunkBits > maxChunkBits) {
            initChunkBits = maxChunkBits;
        }
        this.m_chunkBits = initChunkBits;
        this.m_maxChunkBits = maxChunkBits;
        this.m_rebundleBits = rebundleBits;
        this.m_chunkSize = 1 << initChunkBits;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_array[0] = new byte[this.m_chunkSize];
    }

    public FastByteBuffer(int initChunkBits, int maxChunkBits) {
        this(initChunkBits, maxChunkBits, 2);
    }

    public FastByteBuffer(int initChunkBits) {
        this(initChunkBits, 15, 2);
    }

    public FastByteBuffer() {
        this(6, 10, 3);
    }

    private FastByteBuffer(FastByteBuffer source) {
        this.m_chunkBits = source.m_chunkBits;
        this.m_maxChunkBits = source.m_maxChunkBits;
        this.m_rebundleBits = source.m_rebundleBits;
        this.m_chunkSize = source.m_chunkSize;
        this.m_chunkMask = source.m_chunkMask;
        this.m_array = source.m_array;
        this.m_innerFSB = source.m_innerFSB;
        this.m_lastChunk = source.m_lastChunk - 1;
        this.m_firstFree = source.m_chunkSize;
        source.m_array = new byte[16][];
        source.m_innerFSB = this;
        source.m_lastChunk = 1;
        source.m_firstFree = 0;
        source.m_chunkBits += this.m_rebundleBits;
        source.m_chunkSize = 1 << source.m_chunkBits;
        source.m_chunkMask = source.m_chunkSize - 1;
    }

    @Override
    public final void append(byte value) {
        byte[] chunk;
        boolean lastchunk;
        boolean bl = lastchunk = this.m_lastChunk + 1 == this.m_array.length;
        if (this.m_firstFree < this.m_chunkSize) {
            chunk = this.m_array[this.m_lastChunk];
        } else {
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                byte[][] newarray = new byte[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastByteBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new byte[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            this.m_firstFree = 0;
        }
        chunk[this.m_firstFree++] = value;
    }

    @Override
    public final void append(byte[] chars) {
        this.append(chars, 0, chars.length);
    }

    @Override
    public final void append(byte[] chars, int start, int length) {
        int strlen = length;
        if (0 == strlen) {
            return;
        }
        int copyfrom = start;
        byte[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            System.arraycopy(chars, copyfrom, this.m_array[this.m_lastChunk], this.m_firstFree, available);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                byte[][] newarray = new byte[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastByteBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new byte[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(FastByteBuffer value) {
        if (value == null) {
            return;
        }
        int strlen = value.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        byte[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            int sourcechunk = copyfrom + value.m_chunkSize - 1 >>> value.m_chunkBits;
            int sourcecolumn = copyfrom & value.m_chunkMask;
            int runlength = value.m_chunkSize - sourcecolumn;
            if (runlength > available) {
                runlength = available;
            }
            System.arraycopy(value.m_array[sourcechunk], sourcecolumn, this.m_array[this.m_lastChunk], this.m_firstFree, runlength);
            if (runlength != available) {
                System.arraycopy(value.m_array[sourcechunk + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + runlength, available - runlength);
            }
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                byte[][] newarray = new byte[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastByteBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new byte[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    @Override
    public void copyTo(byte[] newBuf, int offset) {
        int pos = offset;
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(newBuf, pos);
            } else {
                System.arraycopy(this.m_array[i], 0, newBuf, pos, this.m_chunkSize);
            }
            pos += this.m_chunkSize;
        }
        System.arraycopy(this.m_array[this.m_lastChunk], 0, newBuf, pos, this.m_firstFree);
    }

    @Override
    public void copyTo(ByteArray newBuf) {
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(newBuf);
                continue;
            }
            newBuf.append(this.m_array[i]);
        }
        newBuf.append(this.m_array[this.m_lastChunk], 0, this.m_firstFree);
    }

    @Override
    public void copyTo(ByteBuffer newBuf) {
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(newBuf);
                continue;
            }
            newBuf.put(this.m_array[i]);
        }
        newBuf.put(this.m_array[this.m_lastChunk], 0, this.m_firstFree);
    }

    @Override
    public void copyTo(int start, byte[] newBuf, int offset, int len) {
        int stop = start + len;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        int pos = offset;
        for (int i = startChunk; i < stopChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(startColumn, newBuf, offset, this.m_chunkSize - startColumn);
            } else {
                System.arraycopy(this.m_array[i], startColumn, newBuf, pos, this.m_chunkSize - startColumn);
            }
            pos += this.m_chunkSize - startColumn;
            startColumn = 0;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.copyTo(startColumn, newBuf, pos, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            System.arraycopy(this.m_array[stopChunk], startColumn, newBuf, pos, stopColumn - startColumn);
        }
    }

    @Override
    public void copyTo(int start, ByteBuffer buf, int len) {
        int stop = start + len;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(startColumn, buf, this.m_chunkSize - startColumn);
            } else {
                buf.put(this.m_array[i], startColumn, this.m_chunkSize - startColumn);
            }
            startColumn = 0;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.copyTo(startColumn, buf, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            buf.put(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
    }

    public void set(int position, byte b) {
        int chunk = position >>> this.m_chunkBits;
        int column = position & this.m_chunkMask;
        this.m_array[chunk][column] = b;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
        FastByteBuffer innermost = this;
        while (innermost.m_innerFSB != null) {
            innermost = innermost.m_innerFSB;
        }
        this.m_chunkBits = innermost.m_chunkBits;
        this.m_chunkSize = innermost.m_chunkSize;
        this.m_chunkMask = innermost.m_chunkMask;
        this.m_innerFSB = null;
        this.m_array = new byte[16][0];
        this.m_array[0] = new byte[this.m_chunkSize];
    }

    @Override
    public final void setLength(int l) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l, this);
        } else {
            this.m_firstFree = l & this.m_chunkMask;
            if (this.m_firstFree == 0 && this.m_lastChunk > 0) {
                --this.m_lastChunk;
                this.m_firstFree = this.m_chunkSize;
            }
        }
    }

    private final void setLength(int l, FastByteBuffer rootFSB) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l, rootFSB);
        } else {
            rootFSB.m_chunkBits = this.m_chunkBits;
            rootFSB.m_maxChunkBits = this.m_maxChunkBits;
            rootFSB.m_rebundleBits = this.m_rebundleBits;
            rootFSB.m_chunkSize = this.m_chunkSize;
            rootFSB.m_chunkMask = this.m_chunkMask;
            rootFSB.m_array = this.m_array;
            rootFSB.m_innerFSB = this.m_innerFSB;
            rootFSB.m_lastChunk = this.m_lastChunk;
            rootFSB.m_firstFree = l & this.m_chunkMask;
        }
    }

    @Override
    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }
}

