/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.persistent.NodeProxy;
import org.exist.util.HeapSort;
import org.exist.util.InsertionSort;
import org.exist.util.SwapVals;

public final class FastQSort {
    private static final int M = 10;
    private static final double LOG2 = Math.log(2.0);

    private static final <C extends Comparable<? super C>> void IntroSort(C[] a, int lo, int hi) {
        FastQSort.IntroSortLoop(a, (int)lo, (int)hi, (int)(2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2)));
        InsertionSort.sort(a, (int)lo, (int)hi);
    }

    private static final <C extends Comparable<? super C>> void IntroSort(C[] a, int lo, int hi, int[] b) {
        FastQSort.IntroSortLoop(a, (int)lo, (int)hi, (int[])b, (int)(2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2)));
        InsertionSort.sort(a, (int)lo, (int)hi, (int[])b);
    }

    private static final <C> void IntroSort(C[] a, Comparator<C> comp, int lo, int hi) {
        FastQSort.IntroSortLoop(a, comp, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
        InsertionSort.sort(a, comp, lo, hi);
    }

    private static final <C extends Comparable<? super C>> void IntroSort(List<C> a, int lo, int hi) {
        FastQSort.IntroSortLoop(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
        InsertionSort.sort(a, lo, hi);
    }

    private static final void IntroSort(long[] a, int lo, int hi, Object[] b) {
        FastQSort.IntroSortLoop(a, lo, hi, b, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
        InsertionSort.sort(a, lo, hi, b);
    }

    private static final void IntroSortByNodeId(NodeProxy[] a, int lo, int hi) {
        FastQSort.IntroSortLoopByNodeId(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
        InsertionSort.sortByNodeId(a, lo, hi);
    }

    private static final <C extends Comparable<? super C>> void IntroSortLoop(C[] a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, (int)l, (int)r);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                SwapVals.swap(a, i, r);
            }
            C partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a[i]) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoop(a, (int)l, (int)j, (int)maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    private static final <C extends Comparable<? super C>> void IntroSortLoop(C[] a, int l, int r, int[] b, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, (int)l, (int)r, (int[])b);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                SwapVals.swap(a, l, i);
                if (b != null) {
                    SwapVals.swap(b, l, i);
                }
            }
            if (a[l].compareTo(a[r]) > 0) {
                SwapVals.swap(a, l, r);
                if (b != null) {
                    SwapVals.swap(b, l, r);
                }
            }
            if (a[i].compareTo(a[r]) > 0) {
                SwapVals.swap(a, i, r);
                if (b != null) {
                    SwapVals.swap(b, i, r);
                }
            }
            C partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a[i]) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                if (b != null) {
                    SwapVals.swap(b, i, j);
                }
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoop(a, (int)l, (int)j, (int[])b, (int)maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    private static final <C> void IntroSortLoop(C[] a, Comparator<C> comp, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, comp, l, r);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (comp.compare(a[l], a[i]) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (comp.compare(a[l], a[r]) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (comp.compare(a[i], a[r]) > 0) {
                SwapVals.swap(a, i, r);
            }
            C partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && comp.compare(partionElement, a[i]) > 0) {
                    ++i;
                }
                while (j > l && comp.compare(partionElement, a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoop(a, comp, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    private static final <C extends Comparable<? super C>> void IntroSortLoop(List<C> a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (((Comparable)a.get(l)).compareTo(a.get(i)) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (((Comparable)a.get(l)).compareTo(a.get(r)) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (((Comparable)a.get(i)).compareTo(a.get(r)) > 0) {
                SwapVals.swap(a, i, r);
            }
            Comparable partionElement = (Comparable)a.get(i);
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a.get(i)) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a.get(j)) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoop(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    private static final void IntroSortLoop(long[] a, int l, int r, Object[] b, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r, b);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (a[l] > a[i]) {
                SwapVals.swap(a, l, i);
                if (b != null) {
                    SwapVals.swap(b, l, i);
                }
            }
            if (a[l] > a[r]) {
                SwapVals.swap(a, l, r);
                if (b != null) {
                    SwapVals.swap(b, l, r);
                }
            }
            if (a[i] > a[r]) {
                SwapVals.swap(a, i, r);
                if (b != null) {
                    SwapVals.swap(b, i, r);
                }
            }
            long partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement > a[i]) {
                    ++i;
                }
                while (j > l && partionElement < a[j]) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                if (b != null) {
                    SwapVals.swap(b, i, j);
                }
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoop(a, l, j, b, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    private static final void IntroSortLoopByNodeId(NodeProxy[] a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sortByNodeId(a, l, r);
                return;
            }
            --maxdepth;
            int i = (l + r) / 2;
            if (a[l].getNodeId().compareTo(a[i].getNodeId()) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (a[l].getNodeId().compareTo(a[r].getNodeId()) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (a[i].getNodeId().compareTo(a[r].getNodeId()) > 0) {
                SwapVals.swap(a, i, r);
            }
            NodeProxy partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.getNodeId().compareTo(a[i].getNodeId()) > 0) {
                    ++i;
                }
                while (j > l && partionElement.getNodeId().compareTo(a[j].getNodeId()) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortLoopByNodeId(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
    }

    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSort(a, (int)lo, (int)hi);
    }

    public static <C extends Comparable<? super C>> void sort(C[] a, int lo, int hi, int[] b) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSort(a, (int)lo, (int)hi, (int[])b);
    }

    public static <C> void sort(C[] a, Comparator<C> c, int lo, int hi) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSort(a, c, lo, hi);
    }

    public static <C extends Comparable<? super C>> void sort(List<C> a, int lo, int hi) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi);
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSortByNodeId(a, lo, hi);
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        if (lo >= hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, b);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try (BufferedReader is = new BufferedReader(new FileReader(args[0]));){
                String rr;
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
            }
        }
        long a = System.currentTimeMillis();
        FastQSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println((String)l.get(i));
        }
    }
}

