/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.nio.ByteBuffer;
import org.exist.util.ByteArray;

public class FixedByteArray
implements ByteArray {
    private byte[] data;
    private int start;
    private int len;

    public FixedByteArray(byte[] data, int start, int len) {
        this.data = data;
        this.start = start;
        this.len = len;
    }

    public FixedByteArray(byte[] data) {
        this(data, 0, data.length);
    }

    @Override
    public void setLength(int len) {
        throw new RuntimeException("cannot modify fixed byte array");
    }

    public String toString() {
        return new String(this.data, this.start, this.len);
    }

    @Override
    public void copyTo(byte[] b, int offset) {
        System.arraycopy(this.data, this.start, b, offset, this.len);
    }

    @Override
    public void copyTo(int startOffset, byte[] newBuf, int offset, int count) {
        System.arraycopy(this.data, this.start + startOffset, newBuf, offset, count);
    }

    @Override
    public void copyTo(ByteArray other) {
        other.append(this.data, this.start, this.len);
    }

    @Override
    public void copyTo(ByteBuffer buf) {
        buf.put(this.data, this.start, this.len);
    }

    @Override
    public void copyTo(int startOffset, ByteBuffer buf, int count) {
        buf.put(this.data, this.start + startOffset, count);
    }

    @Override
    public void append(byte b) {
        throw new RuntimeException("cannot modify fixed byte array");
    }

    @Override
    public void append(byte[] b) {
        throw new RuntimeException("cannot modify fixed byte array");
    }

    @Override
    public void append(byte[] b, int offset, int length) {
        throw new RuntimeException("cannot modify fixed byte array");
    }

    @Override
    public int size() {
        return this.len;
    }

    public void release() {
    }
}

