/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class NamedThreadFactory
implements ThreadFactory {
    private static final String DEFAULT_THREAD_NAME_PREFIX = "exist";
    private final AtomicLong threadId = new AtomicLong();
    private final String threadNamePrefix;

    public NamedThreadFactory(String nameBase) {
        this(DEFAULT_THREAD_NAME_PREFIX, nameBase);
    }

    public NamedThreadFactory(@Nullable String prefix, String nameBase) {
        Objects.requireNonNull(nameBase);
        this.threadNamePrefix = (prefix == null ? "" : prefix + "-") + nameBase + "-";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new Thread(runnable, this.threadNamePrefix + this.threadId.getAndIncrement());
    }
}

