/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParametersExtractor {
    public static final String PARAMETERS_ELEMENT_NAME = "parameters";
    public static final String PARAMETER_ELEMENT_NAME = "parameter";
    private static final String PARAMETER_NAME_ATTRIBUTE = "name";
    private static final String PARAMETER_VALUE_ATTRIBUTE = "value";

    public static Map<String, List<? extends Object>> extract(Element parameters) {
        Map<String, List<? extends Object>> result;
        if (parameters == null || !parameters.getLocalName().equals(PARAMETERS_ELEMENT_NAME)) {
            result = new HashMap<String, List<? extends Object>>(0);
        } else {
            String namespace = parameters.getNamespaceURI();
            NodeList nlParameter = parameters.getElementsByTagNameNS(namespace, PARAMETER_ELEMENT_NAME);
            result = ParametersExtractor.extract(nlParameter);
        }
        return result;
    }

    public static Map<String, List<? extends Object>> extract(NodeList nlParameter) {
        Map<Object, Object> result = nlParameter == null || nlParameter.getLength() == 0 ? new HashMap(0) : ParametersExtractor.extractParameters(nlParameter);
        return result;
    }

    private static Map<String, List<? extends Object>> extractParameters(NodeList nlParameter) {
        HashMap<String, List<? extends Object>> parameters = new HashMap<String, List<? extends Object>>(nlParameter.getLength());
        for (int i = 0; i < nlParameter.getLength(); ++i) {
            Element param = (Element)nlParameter.item(i);
            String name = param.getAttribute(PARAMETER_NAME_ATTRIBUTE);
            ArrayList<Object> values = (ArrayList<Object>)parameters.get(name);
            String value = param.getAttribute(PARAMETER_VALUE_ATTRIBUTE);
            if (value != null && value.length() > 0) {
                if (values == null) {
                    values = new ArrayList<Object>();
                }
                values.add(value);
            } else if (param.getChildNodes().getLength() > 0) {
                if (values == null) {
                    values = new ArrayList();
                }
                values.add(ParametersExtractor.getParameterChildParameters(param));
            }
            parameters.put(name, (List<? extends Object>)values);
        }
        return parameters;
    }

    private static Map<String, List> getParameterChildParameters(Element parameter) {
        HashMap<String, List> results = new HashMap<String, List>();
        NodeList childParameters = parameter.getChildNodes();
        for (int i = 0; i < childParameters.getLength(); ++i) {
            Node nChildParameter = childParameters.item(i);
            if (!(nChildParameter instanceof Element)) continue;
            Element childParameter = (Element)nChildParameter;
            String name = childParameter.getLocalName();
            if (childParameter.getAttributes().getLength() > 0) {
                ArrayList<Properties> childParameterProperties = (ArrayList<Properties>)results.get(name);
                if (childParameterProperties == null) {
                    childParameterProperties = new ArrayList<Properties>();
                }
                NamedNodeMap attrs = childParameter.getAttributes();
                Properties props = new Properties();
                for (int a = 0; a < attrs.getLength(); ++a) {
                    Node attr = attrs.item(a);
                    props.put(attr.getLocalName(), attr.getNodeValue());
                }
                childParameterProperties.add(props);
                results.put(name, childParameterProperties);
                continue;
            }
            ArrayList<String> strings = (ArrayList<String>)results.get(name);
            if (strings == null) {
                strings = new ArrayList<String>();
            }
            strings.add(childParameter.getTextContent());
            results.put(name, strings);
        }
        return results;
    }

    public static Properties parseParameters(Node nParameters) {
        return ParametersExtractor.parseProperties(nParameters, "param");
    }

    public static Properties parseProperties(Node nProperties) {
        return ParametersExtractor.parseProperties(nProperties, "property");
    }

    public static Properties parseFeatures(Node nFeatures) {
        return ParametersExtractor.parseProperties(nFeatures, "feature");
    }

    private static Properties parseProperties(Node container, String elementName) throws IllegalArgumentException {
        Properties properties = new Properties();
        if (container != null && container.getNodeType() == 1) {
            NodeList params = ((Element)container).getElementsByTagName(elementName);
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                String name = param.getAttribute(PARAMETER_NAME_ATTRIBUTE);
                String value = param.getAttribute(PARAMETER_VALUE_ATTRIBUTE);
                if (name == null || value == null) {
                    if (name == null) {
                        throw new IllegalArgumentException("'name' attribute missing for " + elementName);
                    }
                    throw new IllegalArgumentException("'value' attribute missing for " + elementName);
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }
}

