/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLHelper {
    private static final Logger LOG = LogManager.getLogger(SSLHelper.class);
    private static TrustManager[] nonvalidatingTrustManager = null;
    private static HostnameVerifier dummyHostnameVerifier = null;

    private SSLHelper() {
    }

    private static void createTrustManager() {
        if (nonvalidatingTrustManager == null) {
            nonvalidatingTrustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
    }

    private static void createHostnameVerifier() {
        if (dummyHostnameVerifier == null) {
            dummyHostnameVerifier = (hostname, session) -> true;
        }
    }

    public static boolean initialize(boolean sslAllowSelfsigned, boolean sslVerifyHostname) {
        SSLHelper.createTrustManager();
        SSLHelper.createHostnameVerifier();
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("Unable to initialize SSL.", (Throwable)ex);
            return false;
        }
        if (sslAllowSelfsigned) {
            try {
                LOG.debug("Installing SSL trust manager");
                sc.init(null, nonvalidatingTrustManager, new SecureRandom());
            }
            catch (KeyManagementException ex) {
                LOG.error("Unable to initialize keychain validation.", (Throwable)ex);
                return false;
            }
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        if (!sslVerifyHostname) {
            LOG.debug("Registering hostname verifier");
            HttpsURLConnection.setDefaultHostnameVerifier(dummyHostnameVerifier);
        }
        return true;
    }

    public static boolean initialize() {
        return SSLHelper.initialize(true, false);
    }
}

