/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;

public class SingleInstanceConfiguration
extends Configuration {
    private static final Logger LOG = LogManager.getLogger(SingleInstanceConfiguration.class);
    protected static Optional<Path> _configFile = Optional.empty();
    protected static Optional<Path> _existHome = Optional.empty();

    public SingleInstanceConfiguration() throws DatabaseConfigurationException {
        this("conf.xml", Optional.empty());
    }

    public SingleInstanceConfiguration(String configFilename) throws DatabaseConfigurationException {
        this(configFilename, Optional.empty());
    }

    public SingleInstanceConfiguration(String configFilename, Optional<Path> existHomeDirname) throws DatabaseConfigurationException {
        super(configFilename, existHomeDirname);
        _configFile = this.configFilePath;
        _existHome = this.existHome;
    }

    public static Optional<Path> getPath() {
        if (!_configFile.isPresent()) {
            Path f = ConfigurationHelper.lookup("conf.xml");
            return Optional.of(f.toAbsolutePath());
        }
        return _configFile;
    }

    public static boolean isInWarFile() {
        boolean retVal = true;
        if (!_existHome.isPresent()) {
            _existHome = ConfigurationHelper.getExistHome();
        }
        if (_existHome.map(h -> Files.isDirectory(h.resolve("lib/core"), new LinkOption[0])).orElse(false).booleanValue()) {
            retVal = false;
        }
        return retVal;
    }

    public static Optional<Path> getWebappHome() {
        if (!_existHome.isPresent()) {
            _existHome = ConfigurationHelper.getExistHome();
        }
        return _existHome.map(h -> SingleInstanceConfiguration.isInWarFile() ? h.getParent() : h.resolve("webapp"));
    }
}

