/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.util.Stacktrace;

public abstract class TraceableStateChange<S, C> {
    private final C change;
    private final StackTraceElement[] trace;
    private final S state;
    private final Thread thread;

    public TraceableStateChange(C change, S subject) {
        this.change = change;
        this.trace = Stacktrace.substack(Thread.currentThread().getStackTrace(), 2, 10);
        this.state = subject;
        this.thread = Thread.currentThread();
    }

    public abstract String getId();

    public C getChange() {
        return this.change;
    }

    public S getState() {
        return this.state;
    }

    public String describeState() {
        return this.state.toString();
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    public Thread getThread() {
        return this.thread;
    }
}

