/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.exist.util.Stacktrace;
import org.exist.util.TraceableStateChange;

public class TraceableStateChanges<S, C> {
    private List<TraceableStateChange<S, C>> stateChangeTrace = new ArrayList<TraceableStateChange<S, C>>();

    public void add(TraceableStateChange<S, C> stateChange) {
        this.stateChangeTrace.add(stateChange);
    }

    public void clear() {
        this.stateChangeTrace.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        TraceableStateChanges<S, C> copy = new TraceableStateChanges<S, C>();
        copy.stateChangeTrace = new ArrayList<TraceableStateChange<S, C>>(this.stateChangeTrace);
        return copy;
    }

    public final void logTrace(Logger logger) {
        if (!logger.isTraceEnabled()) {
            throw new IllegalStateException("This is only enabled at TRACE level logging");
        }
        for (int i = 0; i < this.stateChangeTrace.size(); ++i) {
            TraceableStateChange<S, C> traceableStateChange = this.stateChangeTrace.get(i);
            logger.trace(String.format("%d: %s: %s(%s) from: %s(%s)", i + 1, traceableStateChange.getId(), traceableStateChange.getChange(), traceableStateChange.describeState(), traceableStateChange.getThread(), Stacktrace.asString(traceableStateChange.getTrace())));
        }
    }
}

