/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;

public class ValueOccurrences {
    private AtomicValue value;
    private int occurrences = 0;
    private MutableDocumentSet docs = new DefaultDocumentSet();

    public ValueOccurrences(AtomicValue value) {
        this.value = value;
    }

    public AtomicValue getValue() {
        return this.value;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void addOccurrences(int count) {
        this.occurrences += count;
    }

    public void addDocument(DocumentImpl doc) {
        if (!this.docs.contains(doc.getDocId())) {
            this.docs.add(doc);
        }
    }

    public void add(ValueOccurrences other) {
        this.addOccurrences(other.occurrences);
        this.docs.addAll(other.docs);
    }

    public int getDocuments() {
        return this.docs.getDocumentCount();
    }

    public int compareTo(Object o) {
        try {
            return this.value.compareTo(null, ((ValueOccurrences)o).value);
        }
        catch (XPathException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("Value: '").append(this.value.getStringValue()).append("'");
        }
        catch (XPathException e) {
            buf.append("Value: '").append(e.getMessage()).append("'");
        }
        buf.append(" occurences: '").append(this.occurrences).append("'");
        buf.append(" documents: '").append(this.docs.getDocumentCount()).append("'");
        return buf.toString();
    }
}

