/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.exist.util.FileUtils;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;

public class XMLFilenameFilter
implements FilenameFilter {
    @Override
    public boolean accept(File dir, String name) {
        MimeTable mimetab = MimeTable.getInstance();
        MimeType mime = mimetab.getContentTypeFor(name);
        return mime != null && mime.isXMLType();
    }

    public static Predicate<Path> asPredicate() {
        MimeTable mimetab = MimeTable.getInstance();
        return path -> {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                MimeType mime = mimetab.getContentTypeFor(FileUtils.fileName(path));
                return mime != null && mime.isXMLType();
            }
            return false;
        };
    }
}

