/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPoolService;
import org.exist.util.Configuration;
import org.exist.util.ExistSAXParserFactory;
import org.exist.validation.GrammarPool;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderObjectFactory
extends BasePoolableObjectFactory
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(XMLReaderObjectFactory.class);
    public static final String CONFIGURATION_ENTITY_RESOLVER_ELEMENT_NAME = "entity-resolver";
    public static final String CONFIGURATION_CATALOG_ELEMENT_NAME = "catalog";
    public static final String CONFIGURATION_ELEMENT_NAME = "validation";
    public static final String VALIDATION_MODE_ATTRIBUTE = "mode";
    public static final String PROPERTY_VALIDATION_MODE = "validation.mode";
    public static final String CATALOG_RESOLVER = "validation.resolver";
    public static final String CATALOG_URIS = "validation.catalog_uris";
    public static final String GRAMMER_POOL = "validation.grammar_pool";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_PROPERTIES_INTERNAL_GRAMMARPOOL = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String APACHE_PROPERTIES_LOAD_EXT_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String APACHE_PROPERTIES_ENTITYRESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String APACHE_PROPERTIES_NONAMESPACESCHEMALOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private Configuration configuration;
    private GrammarPool grammarPool;
    private eXistXMLCatalogResolver resolver;

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
        this.grammarPool = (GrammarPool)configuration.getProperty(GRAMMER_POOL);
        this.resolver = (eXistXMLCatalogResolver)((Object)configuration.getProperty(CATALOG_RESOLVER));
    }

    public Object makeObject() throws Exception {
        String option = (String)this.configuration.getProperty(PROPERTY_VALIDATION_MODE);
        VALIDATION_SETTING validation = XMLReaderObjectFactory.convertValidationMode(option);
        XMLReader xmlReader = XMLReaderObjectFactory.createXmlReader(validation, this.grammarPool, this.resolver);
        XMLReaderObjectFactory.setReaderValidationMode(validation, xmlReader);
        return xmlReader;
    }

    public static XMLReader createXmlReader(VALIDATION_SETTING validation, GrammarPool grammarPool, eXistXMLCatalogResolver resolver) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = ExistSAXParserFactory.getSAXParserFactory();
        if (validation == VALIDATION_SETTING.AUTO || validation == VALIDATION_SETTING.ENABLED) {
            saxFactory.setValidating(true);
        } else {
            saxFactory.setValidating(false);
        }
        saxFactory.setNamespaceAware(true);
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        if (grammarPool != null) {
            XMLReaderObjectFactory.setReaderProperty(xmlReader, APACHE_PROPERTIES_INTERNAL_GRAMMARPOOL, grammarPool);
        }
        if (resolver != null) {
            XMLReaderObjectFactory.setReaderProperty(xmlReader, APACHE_PROPERTIES_ENTITYRESOLVER, (Object)resolver);
        }
        return xmlReader;
    }

    public static VALIDATION_SETTING convertValidationMode(String option) {
        VALIDATION_SETTING mode = VALIDATION_SETTING.AUTO;
        if (option != null) {
            mode = "true".equals(option) || "yes".equals(option) ? VALIDATION_SETTING.ENABLED : ("auto".equals(option) ? VALIDATION_SETTING.AUTO : VALIDATION_SETTING.DISABLED);
        }
        return mode;
    }

    public static void setReaderValidationMode(VALIDATION_SETTING validation, XMLReader xmlReader) {
        if (validation == VALIDATION_SETTING.UNKNOWN) {
            return;
        }
        XMLReaderObjectFactory.setReaderFeature(xmlReader, "http://xml.org/sax/features/namespace-prefixes", true);
        XMLReaderObjectFactory.setReaderFeature(xmlReader, "http://xml.org/sax/features/validation", validation == VALIDATION_SETTING.AUTO || validation == VALIDATION_SETTING.ENABLED);
        XMLReaderObjectFactory.setReaderFeature(xmlReader, "http://apache.org/xml/features/validation/dynamic", validation == VALIDATION_SETTING.AUTO);
        XMLReaderObjectFactory.setReaderFeature(xmlReader, APACHE_FEATURES_VALIDATION_SCHEMA, validation == VALIDATION_SETTING.AUTO || validation == VALIDATION_SETTING.ENABLED);
        XMLReaderObjectFactory.setReaderFeature(xmlReader, APACHE_PROPERTIES_LOAD_EXT_DTD, validation == VALIDATION_SETTING.AUTO || validation == VALIDATION_SETTING.ENABLED);
    }

    private static void setReaderFeature(XMLReader xmlReader, String featureName, boolean value) {
        try {
            xmlReader.setFeature(featureName, value);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.error("SAXNotRecognizedException: " + ex.getMessage());
        }
        catch (SAXNotSupportedException ex) {
            LOG.error("SAXNotSupportedException:" + ex.getMessage());
        }
    }

    private static void setReaderProperty(XMLReader xmlReader, String propertyName, Object object) {
        try {
            xmlReader.setProperty(propertyName, object);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.error("SAXNotRecognizedException: " + ex.getMessage());
        }
        catch (SAXNotSupportedException ex) {
            LOG.error("SAXNotSupportedException:" + ex.getMessage());
        }
    }

    public static enum VALIDATION_SETTING {
        UNKNOWN,
        ENABLED,
        AUTO,
        DISABLED;

    }
}

