/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPoolService;
import org.exist.validation.GrammarPool;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XMLReaderPool
extends StackObjectPool<XMLReader>
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(XMLReaderPool.class);
    private static final DefaultHandler2 DUMMY_HANDLER = new DefaultHandler2();

    public XMLReaderPool(PoolableObjectFactory<XMLReader> factory, int maxIdle, int initIdleCapacity) {
        super(factory, maxIdle, initIdleCapacity);
    }

    public synchronized XMLReader borrowXMLReader() {
        try {
            return (XMLReader)super.borrowObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("error while returning XMLReader: " + e.getMessage(), e);
        }
    }

    public synchronized XMLReader borrowObject() throws Exception {
        return this.borrowXMLReader();
    }

    public synchronized void returnXMLReader(XMLReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.setContentHandler(DUMMY_HANDLER);
            reader.setErrorHandler(DUMMY_HANDLER);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", DUMMY_HANDLER);
            GrammarPool grammarPool = (GrammarPool)this.getReaderProperty(reader, "http://apache.org/xml/properties/internal/grammar-pool");
            if (grammarPool != null) {
                grammarPool.clearDTDs();
            }
            super.returnObject((Object)reader);
        }
        catch (Exception e) {
            throw new IllegalStateException("error while returning XMLReader: " + e.getMessage(), e);
        }
    }

    public synchronized void returnObject(XMLReader obj) throws Exception {
        this.returnXMLReader(obj);
    }

    private Object getReaderProperty(XMLReader xmlReader, String propertyName) {
        Object object = null;
        try {
            object = xmlReader.getProperty(propertyName);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.error("SAXNotRecognizedException: " + ex.getMessage());
        }
        catch (SAXNotSupportedException ex) {
            LOG.error("SAXNotSupportedException:" + ex.getMessage());
        }
        return object;
    }
}

