/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractHashSet<K>
implements Iterable<K> {
    private static final int DEFAULT_SIZE = 1031;
    protected static final Object REMOVED = new Object();
    protected int tabSize;
    protected int items = 0;
    private int maxRehash = 0;

    AbstractHashSet() {
        this.tabSize = 1031;
    }

    public AbstractHashSet(int iSize) {
        if (iSize < 1) {
            this.tabSize = 1031;
        } else {
            if (!AbstractHashSet.isPrime(iSize)) {
                iSize = iSize * 3 / 2;
                iSize = (int)AbstractHashSet.nextPrime(iSize);
            }
            this.tabSize = iSize;
        }
    }

    public int size() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items == 0;
    }

    private static boolean isPrime(long number) {
        if (number < 2L) {
            return false;
        }
        if (number == 2L) {
            return true;
        }
        if (number % 2L == 0L) {
            return false;
        }
        if (number == 3L) {
            return true;
        }
        if (number % 3L == 0L) {
            return false;
        }
        int y = 2;
        int x = (int)Math.sqrt(number);
        int i = 5;
        while (i <= x) {
            if (number % (long)i == 0L) {
                return false;
            }
            i += y;
            y = 6 - y;
        }
        return true;
    }

    static long nextPrime(long iVal) {
        long retval = iVal;
        while (!AbstractHashSet.isPrime(++retval)) {
        }
        return retval;
    }

    public int getMaxRehash() {
        return this.maxRehash;
    }

    public static final class HashSetOverflowException
    extends Exception {
        private static final long serialVersionUID = -4679763007424266920L;
    }

    abstract class AbstractHashSetIterator<T>
    implements Iterator<T> {
        protected final IteratorType returnType;

        AbstractHashSetIterator(IteratorType type) {
            this.returnType = type;
        }
    }

    static enum IteratorType {
        KEYS,
        VALUES;

    }
}

