/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;
import org.exist.util.hashtable.AbstractHashtable;

@NotThreadSafe
public class Long2ObjectHashMap<V>
extends AbstractHashtable<Long, V> {
    private long[] keys;
    private V[] values;

    public Long2ObjectHashMap() {
        this.keys = new long[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public Long2ObjectHashMap(int iSize) {
        super(iSize);
        this.keys = new long[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void put(long key, V value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            long[] copyKeys = this.keys;
            V[] copyValues = this.values;
            this.tabSize = (int)Long2ObjectHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new long[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyValues[k] == null || copyValues[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public V get(long key) {
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        return null;
    }

    public V remove(long key) {
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            V o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            V o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
        this.items = 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Long2ObjectIterator<Long>(AbstractHashSet.IteratorType.KEYS);
    }

    @Override
    public Iterator<V> valueIterator() {
        return new Long2ObjectIterator(AbstractHashSet.IteratorType.VALUES);
    }

    private V insert(long key, V value) throws AbstractHashSet.HashSetOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return null;
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            V dup = this.values[idx];
            this.values[idx] = value;
            return dup;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                if (bucket == -1) {
                    bucket = idx;
                }
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return null;
                }
                if (this.keys[idx] == key) {
                    V dup = this.values[idx];
                    this.values[idx] = value;
                    return dup;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return null;
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    private int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    private static int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    public class Long2ObjectIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private int idx;

        public Long2ObjectIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.idx == Long2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Long2ObjectHashMap.this.values[this.idx] == null || Long2ObjectHashMap.this.values[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Long2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.idx == Long2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Long2ObjectHashMap.this.values[this.idx] == null || Long2ObjectHashMap.this.values[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Long2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            switch (this.returnType) {
                case VALUES: {
                    return (T)Long2ObjectHashMap.this.values[this.idx++];
                }
                case KEYS: {
                    return (T)Long.valueOf(Long2ObjectHashMap.this.keys[this.idx++]);
                }
            }
            throw new IllegalStateException("This never happens");
        }
    }
}

