/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;
import org.exist.util.hashtable.AbstractHashtable;

@NotThreadSafe
public class Object2ObjectHashMap<K, V>
extends AbstractHashtable<K, V> {
    protected K[] keys;
    protected V[] values;

    Object2ObjectHashMap() {
        this.keys = new Object[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public Object2ObjectHashMap(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void clean() {
        this.keys = new Object[this.tabSize];
        this.values = new Object[this.tabSize];
        this.items = 0;
    }

    public void put(K key, V value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            K[] copyKeys = this.keys;
            V[] copyValues = this.values;
            this.tabSize = (int)Object2ObjectHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public V get(K key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            return this.values[idx];
        }
        return null;
    }

    public int getIndex(K key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1;
        }
        if (this.keys[idx].equals(key)) {
            return idx;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1;
            }
            if (!this.keys[idx].equals(key)) continue;
            return idx;
        }
        return -1;
    }

    public V remove(K key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            this.keys[idx] = REMOVED;
            --this.items;
            V oldVal = this.values[idx];
            this.values[idx] = null;
            return oldVal;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            V oldVal = this.values[idx];
            this.values[idx] = null;
            return oldVal;
        }
        return null;
    }

    private void insert(K key, V value) throws AbstractHashSet.HashSetOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    private int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    private static int hash(Object o) {
        return o.hashCode();
    }

    @Override
    public Iterator<K> iterator() {
        return new Object2ObjectIterator(AbstractHashSet.IteratorType.KEYS);
    }

    @Override
    public Iterator<V> valueIterator() {
        return new Object2ObjectIterator(AbstractHashSet.IteratorType.VALUES);
    }

    public class Object2ObjectIterator<T>
    extends AbstractHashSet.AbstractHashSetIterator<T> {
        private int idx;

        public Object2ObjectIterator(AbstractHashSet.IteratorType type) {
            super(type);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.idx == Object2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Object2ObjectHashMap.this.keys[this.idx] == null || Object2ObjectHashMap.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.idx == Object2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Object2ObjectHashMap.this.keys[this.idx] == null || Object2ObjectHashMap.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != Object2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            switch (this.returnType) {
                case KEYS: {
                    return (T)Object2ObjectHashMap.this.keys[this.idx++];
                }
                case VALUES: {
                    return (T)Object2ObjectHashMap.this.values[this.idx++];
                }
            }
            throw new IllegalStateException("This never happens");
        }
    }
}

