/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.hashtable.AbstractHashSet;

@NotThreadSafe
public class ObjectHashSet<K>
extends AbstractHashSet<K> {
    protected K[] keys;

    ObjectHashSet() {
        this.keys = new Object[this.tabSize];
    }

    public ObjectHashSet(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
    }

    public void add(K key) {
        try {
            this.insert(key);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            K[] copyKeys = this.keys;
            this.tabSize = (int)ObjectHashSet.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyKeys.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.add(copyKeys[k]);
            }
            this.add(key);
        }
    }

    protected void insert(K key) throws AbstractHashSet.HashSetOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            ++this.items;
            return;
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    public boolean contains(K key) {
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx].equals(key)) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (!this.keys[idx].equals(key)) continue;
            return true;
        }
        return false;
    }

    public K remove(K key) {
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            K prevKey = this.keys[idx];
            this.keys[idx] = REMOVED;
            --this.items;
            return prevKey;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            K prevKey = this.keys[idx];
            this.keys[idx] = REMOVED;
            --this.items;
            return prevKey;
        }
        return null;
    }

    private int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    private static int hash(Object o) {
        return o.hashCode();
    }

    public List<K> keys() {
        ArrayList<K> list = new ArrayList<K>(this.items);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[i] == null || this.keys[i] == REMOVED) continue;
            list.add(this.keys[i]);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Iterator<K> iterator() {
        return new ObjectHashSetIterator();
    }

    public Iterator<K> stableIterator() {
        return new ObjectHashSetStableIterator();
    }

    public class ObjectHashSetStableIterator
    implements Iterator<K> {
        private final K[] mKeys;
        private int idx = 0;

        public ObjectHashSetStableIterator() {
            this.mKeys = new Object[ObjectHashSet.this.tabSize];
            System.arraycopy(ObjectHashSet.this.keys, 0, this.mKeys, 0, ObjectHashSet.this.tabSize);
        }

        @Override
        public boolean hasNext() {
            if (this.idx == this.mKeys.length) {
                return false;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != this.mKeys.length) continue;
                return false;
            }
            return true;
        }

        @Override
        public K next() {
            if (this.idx == this.mKeys.length) {
                return null;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != this.mKeys.length) continue;
                return null;
            }
            return this.mKeys[this.idx++];
        }
    }

    public class ObjectHashSetIterator
    implements Iterator<K> {
        private int idx = 0;

        @Override
        public boolean hasNext() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return false;
            }
            while (ObjectHashSet.this.keys[this.idx] == null || ObjectHashSet.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return false;
            }
            return true;
        }

        @Override
        public K next() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return null;
            }
            while (ObjectHashSet.this.keys[this.idx] == null || ObjectHashSet.this.keys[this.idx] == AbstractHashSet.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return null;
            }
            return ObjectHashSet.this.keys[this.idx++];
        }
    }
}

