/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;
import org.exist.util.io.FilterInputStreamCache;

@NotThreadSafe
public class CachingFilterInputStream
extends FilterInputStream {
    private final FilterInputStreamCache cache;
    private int srcOffset = 0;
    private int mark = 0;

    public CachingFilterInputStream(InputStream inputStream) throws InstantiationException {
        super(null);
        if (!(inputStream instanceof CachingFilterInputStream)) {
            throw new InstantiationException("Only CachingFilterInputStream are supported as InputStream");
        }
        this.cache = ((CachingFilterInputStream)inputStream).shareCache();
    }

    public CachingFilterInputStream(FilterInputStreamCache cache) {
        super(null);
        this.cache = cache;
    }

    FilterInputStreamCache getCache() {
        return this.cache;
    }

    FilterInputStreamCache shareCache() {
        this.cache.incrementSharedReferences();
        return this.cache;
    }

    @Override
    public int available() throws IOException {
        return this.getCache().available() - this.srcOffset;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mark = this.srcOffset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.srcOffset = this.mark;
    }

    @Override
    public int read() throws IOException {
        if (this.getCache().isSrcClosed()) {
            throw new IOException("The underlying InputStream has been closed");
        }
        if (this.useCache()) {
            byte data = this.getCache().get(this.srcOffset++);
            return data;
        }
        int data = this.getCache().read();
        if (data == -1) {
            return -1;
        }
        ++this.srcOffset;
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.getCache().isSrcClosed()) {
            throw new IOException("The underlying InputStream has been closed");
        }
        if (this.useCache()) {
            int actualLen = len > this.getCache().getLength() - this.srcOffset ? this.getCache().getLength() - this.srcOffset : len;
            this.getCache().copyTo(this.srcOffset, b, off, actualLen);
            this.srcOffset += actualLen;
            if (actualLen < len) {
                int srcLen = this.getCache().read(b, off + actualLen, len - actualLen);
                if (srcLen == -1) {
                    return actualLen;
                }
                this.srcOffset += srcLen;
                actualLen += srcLen;
            }
            return actualLen;
        }
        int actualLen = this.getCache().read(b, off, len);
        if (actualLen == -1) {
            return actualLen;
        }
        this.srcOffset += actualLen;
        return actualLen;
    }

    public boolean isClosed() {
        return this.getCache().isSrcClosed();
    }

    @Override
    public void close() throws IOException {
        if (!this.getCache().isSrcClosed()) {
            this.getCache().close();
        }
    }

    public int offset() {
        return this.srcOffset;
    }

    public long skipBackwards(long len) {
        if (len == 0L) {
            return 0L;
        }
        long actualLen = Math.min((long)this.srcOffset, len);
        this.srcOffset -= (int)actualLen;
        return actualLen;
    }

    @Override
    public long skip(long len) throws IOException {
        int read;
        if (this.getCache().isSrcClosed()) {
            throw new IOException("The underlying InputStream has been closed");
        }
        if (len < 1L) {
            return 0L;
        }
        if (this.useCache()) {
            long actualLen;
            long l = actualLen = len > (long)(this.getCache().getLength() - this.srcOffset) ? (long)(this.getCache().getLength() - this.srcOffset) : len;
            if (actualLen < len) {
                int read2;
                int toReadFromSrc = (int)(len - actualLen);
                byte[] skipped = new byte[toReadFromSrc];
                int toRead = toReadFromSrc;
                while (toRead > 0 && (read2 = this.getCache().read(skipped, 0, toRead)) != -1) {
                    toRead -= read2;
                    actualLen += (long)read2;
                }
            }
            this.srcOffset += (int)actualLen;
            return actualLen;
        }
        byte[] skipped = new byte[(int)len];
        int toRead = (int)len;
        int totalRead = 0;
        while (toRead > 0 && (read = this.getCache().read(skipped, 0, toRead)) != -1) {
            toRead -= read;
            totalRead += read;
        }
        this.srcOffset += totalRead;
        return totalRead;
    }

    private boolean useCache() {
        return this.getCache().getSrcOffset() > 0 && this.getCache().getLength() > this.srcOffset;
    }

    public void incrementSharedReferences() {
        this.getCache().incrementSharedReferences();
    }

    public void decrementSharedReferences() {
        this.getCache().decrementSharedReferences();
    }
}

