/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheMonitor;

public class FilterInputStreamCacheFactory {
    private static final Logger LOG = LogManager.getLogger(FilterInputStreamCacheFactory.class);

    private FilterInputStreamCacheFactory() {
    }

    public static FilterInputStreamCache getCacheInstance(FilterInputStreamCacheConfiguration cacheConfiguration, InputStream is) throws IOException {
        FilterInputStreamCache cache = new FilterInputStreamCacheFactory().instantiate(cacheConfiguration, is);
        if (cache == null) {
            throw new IOException("Could not load cache for class: " + cacheConfiguration.getCacheClass());
        }
        FilterInputStreamCacheMonitor.getInstance().register(cache);
        return cache;
    }

    private FilterInputStreamCache instantiate(FilterInputStreamCacheConfiguration cacheConfiguration, InputStream is) {
        try {
            Class<?> clazz = Class.forName(cacheConfiguration.getCacheClass());
            Constructor<?> ctor = clazz.getDeclaredConstructor(InputStream.class);
            ctor.setAccessible(true);
            Object obj = ctor.newInstance(is);
            if (!(obj instanceof FilterInputStreamCache)) {
                LOG.error("Invalid cache class: " + clazz.getName());
                return null;
            }
            return (FilterInputStreamCache)obj;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static interface FilterInputStreamCacheConfiguration {
        public String getCacheClass();
    }
}

