/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exist.util.io.FilterInputStreamCache;

public class FilterInputStreamCacheMonitor {
    private static final FilterInputStreamCacheMonitor INSTANCE = new FilterInputStreamCacheMonitor();
    private final ConcurrentMap<FilterInputStreamCache, FilterInputStreamCacheInfo> activeCaches = new ConcurrentHashMap<FilterInputStreamCache, FilterInputStreamCacheInfo>();

    private FilterInputStreamCacheMonitor() {
    }

    public static FilterInputStreamCacheMonitor getInstance() {
        return INSTANCE;
    }

    public void register(FilterInputStreamCache cache) {
        long now = System.currentTimeMillis();
        FilterInputStreamCacheInfo info = new FilterInputStreamCacheInfo(now, cache);
        this.activeCaches.put(cache, info);
    }

    public Collection<FilterInputStreamCacheInfo> getActive() {
        ArrayList<FilterInputStreamCacheInfo> list = new ArrayList<FilterInputStreamCacheInfo>(this.activeCaches.values());
        list.sort(Comparator.comparingLong(FilterInputStreamCacheInfo::getRegistered));
        return list;
    }

    public void deregister(FilterInputStreamCache cache) {
        this.activeCaches.remove(cache);
    }

    public static class FilterInputStreamCacheInfo {
        private final long registered;
        private final FilterInputStreamCache cache;

        public FilterInputStreamCacheInfo(long registered, FilterInputStreamCache cache) {
            this.registered = registered;
            this.cache = cache;
        }

        public long getRegistered() {
            return this.registered;
        }

        public FilterInputStreamCache getCache() {
            return this.cache;
        }
    }
}

