/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexOutputStream
extends FilterOutputStream {
    private final Hex hex = new Hex();
    private boolean doEncode = false;

    public HexOutputStream(OutputStream out, boolean doEncode) {
        super(out);
        this.doEncode = doEncode;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] singleByte = new byte[]{(byte)i};
        this.write(singleByte, 0, 1);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > b.length || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            byte[] data = new byte[len];
            System.arraycopy(b, offset, data, 0, len);
            this.write(data);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.doEncode) {
            this.out.write(this.hex.encode(b));
        } else {
            try {
                this.out.write(this.hex.decode(b));
            }
            catch (DecoderException de) {
                throw new IOException("Unable to decode: " + de.getMessage(), de);
            }
        }
    }
}

