/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exist.util.io.AbstractFilterInputStreamCache;

public class MemoryFilterInputStreamCache
extends AbstractFilterInputStreamCache {
    private ByteArrayOutputStream cache = new ByteArrayOutputStream();

    public MemoryFilterInputStreamCache(InputStream src) {
        super(src);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.cache.write(b, off, len);
    }

    @Override
    public void write(int i) throws IOException {
        this.cache.write(i);
    }

    @Override
    public byte get(int off) {
        return this.cache.toByteArray()[off];
    }

    @Override
    public int getLength() {
        return this.cache.size();
    }

    @Override
    public void copyTo(int cacheOffset, byte[] b, int off, int len) {
        System.arraycopy(this.cache.toByteArray(), cacheOffset, b, off, len);
    }

    @Override
    public void invalidate() throws IOException {
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
    }
}

