/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.LockToken;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.FileInputSource;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

public class Resource
extends File {
    private static final Logger LOG = LogManager.getLogger(Resource.class);
    private static final long serialVersionUID = -3450182389919974961L;
    public static final char separatorChar = '/';
    public static final Properties XML_OUTPUT_PROPERTIES = new Properties();
    public static final int DEFAULT_COLLECTION_PERM = 511;
    public static final int DEFAULT_RESOURCE_PERM = 420;
    private static final SecureRandom random;
    protected XmldbURI uri;
    protected boolean initialized = false;
    private Collection collection = null;
    private DocumentImpl resource = null;
    Path file = null;
    private URLConnection connection = null;
    long lastModified = 0L;

    static File generateFile(String prefix, String suffix, File dir) {
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return new Resource(dir, prefix + Long.toString(n) + suffix);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        return Resource.generateFile(prefix, suffix, directory);
    }

    public Resource(XmldbURI uri) {
        super(uri.toString());
        this.uri = uri;
    }

    public Resource(String uri) {
        this(XmldbURI.create(uri));
    }

    public Resource(File file, String child) {
        this((Resource)file, child);
    }

    public Resource(Resource resource, String child) {
        this(resource.uri.append(child));
    }

    public Resource(String parent, String child) {
        this(XmldbURI.create(parent).append(child));
    }

    @Override
    public Resource getParentFile() {
        XmldbURI parentPath = this.uri.removeLastSegment();
        if (parentPath == XmldbURI.EMPTY_URI) {
            if (this.uri.startsWith(XmldbURI.DB)) {
                return null;
            }
            return new Resource(XmldbURI.DB);
        }
        return new Resource(parentPath);
    }

    @Override
    public Resource getAbsoluteFile() {
        return this;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String getName() {
        return this.uri.lastSegment().toString();
    }

    private void closeFile(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mkdir() {
        BrokerPool db;
        try {
            db = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            return false;
        }
        try (DBBroker broker = db.getBroker();){
            Collection collection = broker.getCollection(this.uri.toCollectionPathURI());
            if (collection != null) {
                boolean bl = true;
                return bl;
            }
            Collection parent_collection = broker.getCollection(this.uri.toCollectionPathURI().removeLastSegment());
            if (parent_collection == null) {
                boolean bl = false;
                return bl;
            }
            TransactionManager tm = db.getTransactionManager();
            try (Txn transaction = tm.beginTransaction();){
                Collection child = broker.getOrCreateCollection(transaction, this.uri.toCollectionPathURI());
                broker.saveCollection(transaction, child);
                tm.commit(transaction);
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                boolean bl = false;
                if (broker == null) return bl;
                if (var3_5 != null) {
                    try {
                        broker.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                        return bl;
                    }
                }
                broker.close();
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mkdirs() {
        BrokerPool db;
        try {
            db = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            return false;
        }
        try (DBBroker broker = db.getBroker();){
            Collection collection = broker.getCollection(this.uri.toCollectionPathURI());
            if (collection != null) {
                boolean bl = true;
                return bl;
            }
            TransactionManager tm = db.getTransactionManager();
            try (Txn transaction = tm.beginTransaction();){
                Collection child = broker.getOrCreateCollection(transaction, this.uri.toCollectionPathURI());
                broker.saveCollection(transaction, child);
                tm.commit(transaction);
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                boolean bl = false;
                if (broker == null) return bl;
                if (var3_5 != null) {
                    try {
                        broker.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                        return bl;
                    }
                }
                broker.close();
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            this.init();
        }
        catch (IOException e) {
            return false;
        }
        return this.resource == null;
    }

    @Override
    public boolean isFile() {
        try {
            this.init();
        }
        catch (IOException e) {
            return false;
        }
        return this.resource != null;
    }

    @Override
    public boolean exists() {
        try {
            this.init();
        }
        catch (IOException e) {
            return false;
        }
        return this.collection != null || this.resource != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean _renameTo(File dest) {
        TransactionManager tm;
        XmldbURI destinationPath = ((Resource)dest).uri;
        BrokerPool db = null;
        try {
            db = BrokerPool.getInstance();
            tm = db.getTransactionManager();
        }
        catch (EXistException e) {
            return false;
        }
        Collection destination = null;
        Collection source = null;
        try {
            boolean bl;
            Throwable throwable;
            DBBroker broker;
            block55: {
                block56: {
                    DocumentImpl doc;
                    block51: {
                        boolean bl2;
                        block52: {
                            block53: {
                                block48: {
                                    boolean bl3;
                                    block49: {
                                        block50: {
                                            block45: {
                                                boolean bl4;
                                                block46: {
                                                    block47: {
                                                        broker = db.getBroker();
                                                        throwable = null;
                                                        source = broker.openCollection(this.uri.removeLastSegment(), Lock.LockMode.WRITE_LOCK);
                                                        if (source != null) break block45;
                                                        bl4 = false;
                                                        if (broker == null) break block46;
                                                        if (throwable == null) break block47;
                                                        try {
                                                            broker.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        break block46;
                                                    }
                                                    broker.close();
                                                }
                                                return bl4;
                                            }
                                            doc = source.getDocument(broker, this.uri.lastSegment());
                                            if (doc != null) break block48;
                                            bl3 = false;
                                            if (broker == null) break block49;
                                            if (throwable == null) break block50;
                                            try {
                                                broker.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            break block49;
                                        }
                                        broker.close();
                                    }
                                    return bl3;
                                }
                                destination = broker.openCollection(destinationPath.removeLastSegment(), Lock.LockMode.WRITE_LOCK);
                                if (destination != null) break block51;
                                bl2 = false;
                                if (broker == null) break block52;
                                if (throwable == null) break block53;
                                try {
                                    broker.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block52;
                            }
                            broker.close();
                        }
                        return bl2;
                    }
                    XmldbURI newName = destinationPath.lastSegment();
                    try (Txn transaction = tm.beginTransaction();){
                        broker.moveResource(transaction, doc, destination, newName);
                        tm.commit(transaction);
                    }
                    bl = true;
                    if (broker == null) break block55;
                    if (throwable == null) break block56;
                    try {
                        broker.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block55;
                }
                broker.close();
            }
            return bl;
            catch (Throwable throwable6) {
                try {
                    try {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (broker != null) {
                            if (throwable != null) {
                                try {
                                    broker.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                broker.close();
                            }
                        }
                        throw throwable7;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl5 = false;
                    return bl5;
                }
            }
        }
        finally {
            if (source != null) {
                source.release(Lock.LockMode.WRITE_LOCK);
            }
            if (destination != null) {
                destination.release(Lock.LockMode.WRITE_LOCK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean renameTo(File dest) {
        BrokerPool db;
        XmldbURI destinationPath = ((Resource)dest).uri;
        try {
            db = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            return false;
        }
        try {
            Throwable throwable = null;
            try (DBBroker broker = db.getBroker();){
                boolean bl;
                Throwable throwable2;
                Txn transaction;
                Collection source;
                Collection destination;
                block66: {
                    block67: {
                        DocumentImpl doc;
                        block65: {
                            block64: {
                                block63: {
                                    destination = null;
                                    source = null;
                                    source = broker.openCollection(this.uri.removeLastSegment(), Lock.LockMode.WRITE_LOCK);
                                    if (source != null) break block63;
                                    boolean bl2 = false;
                                    if (source != null) {
                                        source.release(Lock.LockMode.WRITE_LOCK);
                                    }
                                    if (destination != null) {
                                        destination.release(Lock.LockMode.WRITE_LOCK);
                                    }
                                    return bl2;
                                }
                                doc = source.getDocument(broker, this.uri.lastSegment());
                                if (doc != null) break block64;
                                boolean bl3 = false;
                                if (source != null) {
                                    source.release(Lock.LockMode.WRITE_LOCK);
                                }
                                if (destination != null) {
                                    destination.release(Lock.LockMode.WRITE_LOCK);
                                }
                                return bl3;
                            }
                            destination = broker.openCollection(destinationPath.removeLastSegment(), Lock.LockMode.WRITE_LOCK);
                            if (destination != null) break block65;
                            boolean bl4 = false;
                            if (source != null) {
                                source.release(Lock.LockMode.WRITE_LOCK);
                            }
                            if (destination != null) {
                                destination.release(Lock.LockMode.WRITE_LOCK);
                            }
                            return bl4;
                        }
                        XmldbURI newName = destinationPath.lastSegment();
                        TransactionManager tm = db.getTransactionManager();
                        transaction = tm.beginTransaction();
                        throwable2 = null;
                        this.moveResource(broker, transaction, doc, source, destination, newName);
                        tm.commit(transaction);
                        bl = true;
                        if (transaction == null) break block66;
                        if (throwable2 == null) break block67;
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block66;
                    }
                    transaction.close();
                }
                if (source != null) {
                    source.release(Lock.LockMode.WRITE_LOCK);
                }
                if (destination != null) {
                    destination.release(Lock.LockMode.WRITE_LOCK);
                }
                return bl;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (transaction != null) {
                                    if (throwable2 != null) {
                                        try {
                                            transaction.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        transaction.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            boolean bl5 = false;
                            if (source != null) {
                                source.release(Lock.LockMode.WRITE_LOCK);
                            }
                            if (destination != null) {
                                destination.release(Lock.LockMode.WRITE_LOCK);
                            }
                            if (broker != null) {
                                if (throwable != null) {
                                    try {
                                        broker.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    broker.close();
                                }
                            }
                            return bl5;
                        }
                    }
                    catch (Throwable throwable8) {
                        try {
                            if (source != null) {
                                source.release(Lock.LockMode.WRITE_LOCK);
                            }
                            if (destination != null) {
                                destination.release(Lock.LockMode.WRITE_LOCK);
                            }
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            throwable = throwable9;
                            throw throwable9;
                        }
                    }
                }
            }
        }
        catch (EXistException e) {
            return false;
        }
    }

    private synchronized Path serialize(DBBroker broker, DocumentImpl doc) throws IOException {
        if (this.file != null) {
            throw new IOException(doc.getFileURI().toString() + " locked.");
        }
        try {
            Serializer serializer = broker.getSerializer();
            serializer.setUser(broker.getCurrentSubject());
            serializer.setProperties(XML_OUTPUT_PROPERTIES);
            this.file = Files.createTempFile("eXist-resource-", ".xml", new FileAttribute[0]);
            this.file.toFile().deleteOnExit();
            try (BufferedWriter w = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
                serializer.serialize(doc, (Writer)w);
            }
            return this.file;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void freeFile() throws IOException {
        if (this.isXML()) {
            if (this.file == null) {
                return;
            }
            FileUtils.deleteQuietly(this.file);
            this.file = null;
        }
    }

    protected synchronized void uploadTmpFile() throws IOException {
        BrokerPool db;
        if (this.file == null) {
            throw new IOException();
        }
        try {
            db = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new IOException(e);
        }
        TransactionManager tm = db.getTransactionManager();
        try (DBBroker broker = db.getBroker();
             Txn txn = tm.beginTransaction();){
            FileInputSource is = new FileInputSource(this.file);
            IndexInfo info = this.collection.validateXMLResource(txn, broker, this.uri.lastSegment(), is);
            is = new FileInputSource(this.file);
            this.collection.store(txn, broker, info, is);
            tm.commit(txn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveResource(DBBroker broker, Txn txn, DocumentImpl doc, Collection source, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException, SAXException, EXistException {
        MimeTable mimeTable = MimeTable.getInstance();
        boolean isXML = mimeTable.isXMLContent(newName.toString());
        MimeType mimeType = mimeTable.getContentTypeFor(newName);
        if (mimeType != null && !mimeType.getName().equals(doc.getMetadata().getMimeType())) {
            doc.getMetadata().setMimeType(mimeType.getName());
            broker.storeXMLResource(txn, doc);
            doc = source.getDocument(broker, this.uri.lastSegment());
        }
        if (isXML) {
            if (doc.getResourceType() == 0) {
                broker.moveResource(txn, doc, destination, newName);
            } else {
                Path file = broker.getBinaryFile((BinaryDocument)doc);
                FileInputSource is = new FileInputSource(file);
                IndexInfo info = destination.validateXMLResource(txn, broker, newName, is);
                info.getDocument().getMetadata().setMimeType(mimeType.getName());
                is = new FileInputSource(file);
                destination.store(txn, broker, info, is);
                source.removeBinaryResource(txn, broker, doc);
            }
        } else if (doc.getResourceType() == 1) {
            broker.moveResource(txn, doc, destination, newName);
        } else {
            Serializer serializer = broker.getSerializer();
            serializer.setUser(broker.getCurrentSubject());
            serializer.setProperties(XML_OUTPUT_PROPERTIES);
            File tempFile = null;
            FileInputStream is = null;
            try {
                tempFile = File.createTempFile("eXist-resource-", ".xml");
                tempFile.deleteOnExit();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
                serializer.serialize(doc, (Writer)w);
                ((Writer)w).flush();
                ((Writer)w).close();
                is = new FileInputStream(tempFile);
                DocumentMetadata meta = doc.getMetadata();
                Date created = new Date(meta.getCreated());
                Date lastModified = new Date(meta.getLastModified());
                BinaryDocument binary = destination.validateBinaryResource(txn, broker, newName);
                binary = destination.addBinaryResource(txn, broker, binary, (InputStream)is, mimeType.getName(), -1L, created, lastModified);
                source.removeXMLResource(txn, broker, doc.getFileURI());
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean delete() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 43[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean createNewFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[CATCHBLOCK], 1[TRYBLOCK], 6[TRYBLOCK], 7[TRYBLOCK], 30[CATCHBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() throws IOException {
        block25: {
            if (this.initialized) {
                this.collection = null;
                this.resource = null;
                this.initialized = false;
            }
            try {
                BrokerPool db = BrokerPool.getInstance();
                try (DBBroker broker = db.getBroker();){
                    if (this.uri.endsWith("/")) {
                        this.collection = broker.getCollection(this.uri);
                        if (this.collection == null) {
                            throw new IOException("Resource not found: " + this.uri);
                        }
                        break block25;
                    }
                    try {
                        this.resource = broker.getXMLResource(this.uri, Lock.LockMode.READ_LOCK);
                        if (this.resource == null) {
                            this.collection = broker.getCollection(this.uri);
                            if (this.collection == null) {
                                throw new IOException("Resource not found: " + this.uri);
                            }
                        } else {
                            this.collection = this.resource.getCollection();
                        }
                    }
                    finally {
                        if (this.resource != null) {
                            this.resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.initialized = true;
    }

    private Permission getPermission() throws IOException {
        this.init();
        if (this.resource != null) {
            return this.resource.getPermissions();
        }
        if (this.collection != null) {
            return this.collection.getPermissionsNoLock();
        }
        throw new IOException("this never should happen");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Subject getBrokerUser() throws IOException {
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.getBroker();){
                Subject subject = broker.getCurrentSubject();
                return subject;
            }
        }
        catch (EXistException e) {
            throw new IOException(e);
        }
    }

    public Reader getReader() throws IOException {
        InputStream is = this.getConnection().getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        return new InputStreamReader(bis);
    }

    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getReader());
    }

    private URLConnection getConnection() throws IOException {
        if (this.connection == null) {
            try {
                BrokerPool db = BrokerPool.getInstance();
                try (DBBroker broker = db.getBroker();){
                    Subject subject = broker.getCurrentSubject();
                    URL url = new URL("xmldb:exist://jsessionid:" + subject.getSessionId() + "@" + this.uri.toString());
                    this.connection = url.openConnection();
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (MalformedURLException e) {
                throw new IOException(e);
            }
            catch (EXistException e) {
                throw new IOException(e);
            }
        }
        return this.connection;
    }

    public InputStream getInputStream() throws IOException {
        return this.getConnection().getInputStream();
    }

    public Writer getWriter() throws IOException {
        return new BufferedWriter(new OutputStreamWriter(this.getOutputStream(false)));
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        if (append) {
            LOG.error("BUG: OutputStream in append mode!");
        }
        return this.getConnection().getOutputStream();
    }

    public DocumentImpl getDocument() throws IOException {
        this.init();
        return this.resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getCollection() throws IOException {
        if (this.initialized) {
            if (this.resource != null) return this.resource.getCollection();
            return this.collection;
        }
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.getBroker();){
                if (this.uri.endsWith("/")) {
                    this.collection = broker.getCollection(this.uri);
                } else {
                    this.collection = broker.getCollection(this.uri);
                    if (this.collection == null) {
                        this.collection = broker.getCollection(this.uri.removeLastSegment());
                    }
                }
                if (this.collection == null) {
                    throw new IOException("Collection not found: " + this.uri);
                }
                Collection collection = this.collection;
                return collection;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] list() {
        if (!this.isDirectory()) return new String[0];
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.getBroker();){
                ArrayList<String> list = new ArrayList<String>();
                for (Collection.CollectionEntry entry : this.collection.getEntries(broker)) {
                    list.add(entry.getUri().lastSegment().toString());
                }
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
        }
        catch (EXistException | PermissionDeniedException | LockException e) {
            LOG.error((Object)e);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public File[] listFiles() {
        File[] fileArray;
        Throwable throwable;
        DBBroker broker;
        block28: {
            block29: {
                if (!this.isDirectory()) {
                    return null;
                }
                if (this.collection == null) {
                    return null;
                }
                BrokerPool db = BrokerPool.getInstance();
                broker = db.getBroker();
                throwable = null;
                this.collection.getLock().acquire(Lock.LockMode.READ_LOCK);
                File[] children = new File[this.collection.getChildCollectionCount(broker) + this.collection.getDocumentCount(broker)];
                int j = 0;
                Iterator<XmldbURI> i = this.collection.collectionIterator(broker);
                while (i.hasNext()) {
                    children[j] = new Resource(this.collection.getURI().append(i.next()));
                    ++j;
                }
                ArrayList<XmldbURI> allresources = new ArrayList<XmldbURI>();
                DocumentImpl doc = null;
                Iterator<DocumentImpl> i2 = this.collection.iterator(broker);
                while (i2.hasNext()) {
                    doc = i2.next();
                    LockToken lock = doc.getMetadata().getLockToken();
                    if (lock != null && lock.isNullResource()) continue;
                    allresources.add(doc.getURI());
                }
                i2 = allresources.iterator();
                while (i2.hasNext()) {
                    children[j] = new Resource((XmldbURI)((Object)i2.next()));
                    ++j;
                }
                fileArray = children;
                if (broker == null) break block28;
                if (throwable == null) break block29;
                try {
                    broker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block28;
            }
            broker.close();
        }
        this.collection.release(Lock.LockMode.READ_LOCK);
        return fileArray;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (broker != null) {
                        if (throwable != null) {
                            try {
                                broker.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            broker.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (LockException e) {
                throwable = null;
                this.collection.release(Lock.LockMode.READ_LOCK);
                return throwable;
            }
            catch (Exception e) {
                try {
                    throwable = null;
                    this.collection.release(Lock.LockMode.READ_LOCK);
                    return throwable;
                }
                catch (Throwable throwable6) {
                    try {
                        this.collection.release(Lock.LockMode.READ_LOCK);
                        throw throwable6;
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
            }
        }
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        throw new IllegalAccessError("not implemeted");
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        throw new IllegalAccessError("not implemeted");
    }

    @Override
    public synchronized long length() {
        try {
            this.init();
        }
        catch (IOException e) {
            return 0L;
        }
        if (this.resource != null && this.resource instanceof BinaryDocument) {
            return this.resource.getContentLength();
        }
        return 0L;
    }

    private static XmldbURI normalize(XmldbURI uri) {
        return uri.startsWith(XmldbURI.ROOT_COLLECTION_URI) ? uri : uri.prepend(XmldbURI.ROOT_COLLECTION_URI);
    }

    @Override
    public String getPath() {
        return Resource.normalize(this.uri).toString();
    }

    @Override
    public String getAbsolutePath() {
        return Resource.normalize(this.uri).toString();
    }

    public boolean isXML() throws IOException {
        this.init();
        if (this.resource != null) {
            return !(this.resource instanceof BinaryDocument);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Path getFile() throws FileNotFoundException {
        DocumentImpl doc;
        if (this.isDirectory()) {
            throw new FileNotFoundException("unsupported operation for collection.");
        }
        try {
            if (!this.exists()) {
                this.createNewFile();
            }
            doc = this.getDocument();
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.getBroker();){
                if (doc instanceof BinaryDocument) {
                    Path path = broker.getBinaryFile((BinaryDocument)doc);
                    return path;
                }
                Path path = this.serialize(broker, doc);
                return path;
            }
        }
        catch (Exception e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    @Override
    public boolean setReadOnly() {
        try {
            this.modifyMetadata(new ModifyMetadata(){

                @Override
                public void modify(DocumentImpl resource) throws IOException {
                    Permission perm = resource.getPermissions();
                    try {
                        perm.setMode(perm.getMode() | 0x100);
                    }
                    catch (PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public void modify(Collection collection) throws IOException {
                    Permission perm = collection.getPermissionsNoLock();
                    try {
                        perm.setMode(perm.getMode() | 0x100);
                    }
                    catch (PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        try {
            this.modifyMetadata(new ModifyMetadata(){

                @Override
                public void modify(DocumentImpl resource) throws IOException {
                    Permission perm = resource.getPermissions();
                    try {
                        perm.setMode(perm.getMode() | 0x40);
                    }
                    catch (PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public void modify(Collection collection) throws IOException {
                    Permission perm = collection.getPermissionsNoLock();
                    try {
                        perm.setMode(perm.getMode() | 0x40);
                    }
                    catch (PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canExecute() {
        try {
            return this.getPermission().validate(this.getBrokerUser(), 1);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.getPermission().validate(this.getBrokerUser(), 4);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean setLastModified(final long time) {
        this.lastModified = time;
        try {
            this.modifyMetadata(new ModifyMetadata(){

                @Override
                public void modify(DocumentImpl resource) throws IOException {
                    resource.getMetadata().setLastModified(time);
                }

                @Override
                public void modify(Collection collection) throws IOException {
                    throw new IOException("LastModified can't be set for collection.");
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public long lastModified() {
        try {
            this.init();
        }
        catch (IOException e) {
            return this.lastModified;
        }
        if (this.resource != null) {
            return this.resource.getMetadata().getLastModified();
        }
        if (this.collection != null) {
            return this.collection.getCreationTime();
        }
        return this.lastModified;
    }

    private void modifyMetadata(ModifyMetadata method) throws IOException {
        block50: {
            BrokerPool db;
            try {
                db = BrokerPool.getInstance();
            }
            catch (EXistException e) {
                throw new IOException(e);
            }
            try (DBBroker broker = db.getBroker();){
                TransactionManager tm = db.getTransactionManager();
                try {
                    if (this.uri.endsWith("/")) {
                        this.collection = broker.getCollection(this.uri);
                        if (this.collection == null) {
                            throw new IOException("Resource not found: " + this.uri);
                        }
                        break block50;
                    }
                    this.resource = broker.getXMLResource(this.uri, Lock.LockMode.READ_LOCK);
                    if (this.resource == null) {
                        this.collection = broker.getCollection(this.uri);
                        if (this.collection == null) {
                            throw new IOException("Resource not found: " + this.uri);
                        }
                        try (Txn txn = tm.beginTransaction();){
                            method.modify(this.collection);
                            broker.saveCollection(txn, this.collection);
                            tm.commit(txn);
                            break block50;
                        }
                    }
                    this.collection = this.resource.getCollection();
                    try (Txn txn = tm.beginTransaction();){
                        method.modify(this.resource);
                        broker.storeMetadata(txn, this.resource);
                        tm.commit(txn);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    throw new IOException(e);
                }
                finally {
                    if (this.resource != null) {
                        this.resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            catch (EXistException e) {
                LOG.error((Object)e);
                throw new IOException(e);
            }
        }
        this.initialized = true;
    }

    static {
        XML_OUTPUT_PROPERTIES.setProperty("indent", "yes");
        XML_OUTPUT_PROPERTIES.setProperty("encoding", "UTF-8");
        XML_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "no");
        XML_OUTPUT_PROPERTIES.setProperty("expand-xincludes", "no");
        XML_OUTPUT_PROPERTIES.setProperty("process-xsl-pi", "no");
        random = new SecureRandom();
    }

    static interface ModifyMetadata {
        public void modify(DocumentImpl var1) throws IOException;

        public void modify(Collection var1) throws IOException;
    }
}

