/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.util.FileUtils;

public class TemporaryFileManager {
    private static final Log LOG = LogFactory.getLog(TemporaryFileManager.class);
    private static final String FOLDER_PREFIX = "_mmtfm_";
    private final Stack<Path> available = new Stack();
    private final Path tmpFolder;
    private static final TemporaryFileManager instance = new TemporaryFileManager();

    public static TemporaryFileManager getInstance() {
        return instance;
    }

    private TemporaryFileManager() {
        this.cleanupOldTempFolders();
        try {
            this.tmpFolder = Files.createTempDirectory(FOLDER_PREFIX + UUID.randomUUID().toString(), new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary folder", ioe);
        }
        this.tmpFolder.toFile().deleteOnExit();
        LOG.info((Object)("Temporary folder is: " + this.tmpFolder.toAbsolutePath().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Path getTemporaryFile() throws IOException {
        Path tempFile = null;
        Stack<Path> stack = this.available;
        synchronized (stack) {
            if (!this.available.empty()) {
                tempFile = this.available.pop();
            }
        }
        if (tempFile == null) {
            tempFile = Files.createTempFile(this.tmpFolder, "mmtf_" + System.currentTimeMillis(), ".tmp", new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTemporaryFile(Path tempFile) {
        if (Files.exists(tempFile, new LinkOption[0])) {
            boolean deleted = false;
            try {
                deleted = Files.deleteIfExists(tempFile);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to delete temporary file: " + tempFile.toAbsolutePath().toString()), (Throwable)e);
            }
            if (deleted) {
                LOG.debug((Object)("Deleted temporary file: " + tempFile.toAbsolutePath().toString()));
            } else {
                LOG.debug((Object)("Could not delete temporary file: " + tempFile.toAbsolutePath().toString() + ". Returning to stack for re-use."));
                Stack<Path> stack = this.available;
                synchronized (stack) {
                    if (this.available.contains(tempFile)) {
                        LOG.debug((Object)("Temporary file: " + tempFile.toAbsolutePath().toString() + " already in stack. Skipping."));
                    } else {
                        this.available.push(tempFile);
                    }
                }
            }
        } else {
            LOG.debug((Object)("Trying to delete non existing file: " + tempFile.toAbsolutePath().toString()));
        }
    }

    private void cleanupOldTempFolders() {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        try (Stream<Path> tmpFiles = Files.list(tmpDir);){
            tmpFiles.filter(path -> Files.isDirectory(path, new LinkOption[0]) && path.startsWith(FOLDER_PREFIX)).forEach(FileUtils::deleteQuietly);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Unable to delete old temporary folders", (Throwable)ioe);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.available.clear();
            FileUtils.deleteQuietly(this.tmpFolder);
        }
        finally {
            super.finalize();
        }
    }
}

