/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.dom.memtree.NamespaceNode;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.IndentingXMLWriter;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.util.serializer.XMLWriter;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InlineFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Attr;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class AdaptiveWriter
extends IndentingXMLWriter {
    private final XMLWriter textWriter;
    private final DBBroker broker;

    public AdaptiveWriter(DBBroker broker, Properties outputProperties, XMLWriter textWriter) {
        this.broker = broker;
        this.textWriter = textWriter;
        this.setWriter(textWriter.getWriter());
        this.setOutputProperties(outputProperties);
    }

    public void write(Sequence sequence, String itemSep, boolean enclose) throws SAXException, XPathException, TransformerException {
        try {
            if (enclose && sequence.getItemCount() != 1) {
                this.writer.write(40);
            }
            SequenceIterator si = sequence.iterate();
            while (si.hasNext()) {
                Item item = si.nextItem();
                switch (item.getType()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 501: {
                        this.writeXML(item);
                        break;
                    }
                    case 2: {
                        Attr node = (Attr)((NodeValue)item).getNode();
                        this.writeText(node.getName() + "=\"" + node.getValue() + '\"');
                        break;
                    }
                    case 500: {
                        NamespaceNode ns = (NamespaceNode)item;
                        this.writeText(ns.getName() + "=\"" + ns.getValue() + '\"');
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 25: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        String v = item.getStringValue();
                        this.writeText('\"' + this.escapeQuotes(v) + '\"');
                        break;
                    }
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.writeText(item.getStringValue());
                        break;
                    }
                    case 34: {
                        this.writeDouble((DoubleValue)item);
                        break;
                    }
                    case 23: {
                        this.writeText(item.getStringValue() + "()");
                        break;
                    }
                    case 24: 
                    case 28: {
                        QName qn = ((QNameValue)item).getQName();
                        this.writeText("Q{" + qn.getNamespaceURI() + '}' + qn.getLocalPart());
                        break;
                    }
                    case 103: {
                        this.writeArray((ArrayType)item);
                        break;
                    }
                    case 102: {
                        this.writeMap((AbstractMapType)item);
                        break;
                    }
                    case 101: {
                        this.writeFunctionItem((FunctionReference)item);
                        break;
                    }
                    default: {
                        this.writeAtomic(item.atomize());
                    }
                }
                if (!si.hasNext()) continue;
                try {
                    this.writer.write(itemSep);
                }
                catch (IOException e) {
                    throw new SAXException(e.getMessage());
                }
            }
            if (enclose && sequence.getItemCount() != 1) {
                this.writer.write(41);
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void writeText(CharSequence str) throws SAXException {
        try {
            this.textWriter.characters(str);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeAtomic(AtomicValue value) throws IOException, SAXException, XPathException {
        StringBuilder sb = new StringBuilder();
        sb.append(Type.getTypeName(value.getType()));
        sb.append("(\"");
        sb.append(value.getStringValue());
        sb.append("\")");
        this.writeText(sb);
    }

    private void writeDouble(DoubleValue item) throws XPathException, SAXException {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
        symbols.setExponentSeparator("e");
        DecimalFormat df = new DecimalFormat("0.0##########################E0", symbols);
        this.writeText(df.format(item.getDouble()));
    }

    private void writeArray(ArrayType array) throws XPathException, SAXException, TransformerException {
        try {
            this.writer.write(91);
            for (int i = 0; i < array.getSize(); ++i) {
                if (i > 0) {
                    this.writer.write(44);
                }
                Sequence member = array.get(i);
                this.write(member, ",", true);
            }
            this.writer.write(93);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeMap(AbstractMapType map) throws SAXException, XPathException, TransformerException {
        try {
            this.writer.write("map");
            this.addSpaceIfIndent();
            this.writer.write(123);
            this.addIndent();
            this.indent();
            Iterator i = map.iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                this.write((Sequence)entry.getKey(), "", false);
                this.writer.write(58);
                this.addSpaceIfIndent();
                this.write((Sequence)entry.getValue(), ",", true);
                if (!i.hasNext()) continue;
                this.writer.write(44);
                this.indent();
            }
            this.endIndent(null, null);
            this.indent();
            this.writer.write(125);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeFunctionItem(FunctionReference item) throws XPathException, SAXException {
        String name;
        FunctionReference ref = item;
        FunctionSignature signature = ref.getSignature();
        QName fn = signature.getName();
        if (fn == InlineFunction.INLINE_FUNCTION_QNAME) {
            name = "(anonymous-function)";
        } else {
            switch (fn.getNamespaceURI()) {
                case "http://www.w3.org/2005/xpath-functions": {
                    name = "fn:" + fn.getLocalPart();
                    break;
                }
                case "http://www.w3.org/2005/xpath-functions/math": {
                    name = "math:" + fn.getLocalPart();
                    break;
                }
                case "http://www.w3.org/2005/xpath-functions/map": {
                    name = "map:" + fn.getLocalPart();
                    break;
                }
                case "http://www.w3.org/2005/xpath-functions/array": {
                    name = "array:" + fn.getLocalPart();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema": {
                    name = "xs:" + fn.getLocalPart();
                    break;
                }
                default: {
                    name = "Q{" + fn.getNamespaceURI() + '}' + fn.getLocalPart();
                }
            }
        }
        this.writeText(name + '#' + signature.getArgumentCount());
    }

    private String escapeQuotes(String value) {
        StringBuilder sb = new StringBuilder(value.length() + 5);
        block3: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append(ch);
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private void writeXML(Item item) throws SAXException {
        Properties xmlProperties = new Properties(this.outputProperties);
        xmlProperties.setProperty("method", "xml");
        Serializer serializer = this.broker.getSerializer();
        serializer.reset();
        SAXSerializer sax = null;
        try {
            sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            sax.setOutput(this.writer, xmlProperties);
            serializer.setProperties(xmlProperties);
            serializer.setSAXHandlers(sax, sax);
            serializer.toSAX(item, false, false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            if (sax != null) {
                SerializerPool.getInstance().returnObject(sax);
            }
        }
    }
}

