/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.nio.CharBuffer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.serializer.IndentingXMLWriter;

public class MicroXmlWriter
extends IndentingXMLWriter {
    private String removePrefix(String qname) {
        int prefixDelimIdx = qname.indexOf(58);
        String result = prefixDelimIdx > -1 ? qname.substring(prefixDelimIdx + 1) : qname;
        return result;
    }

    private QName removePrefix(QName qname) {
        return new QName(qname.getLocalPart(), "");
    }

    private CharSequence removeRestrictedChars(CharSequence charSeq) {
        CharBuffer buf = CharBuffer.allocate(charSeq.length());
        block3: for (int i = 0; i < charSeq.length(); ++i) {
            switch (charSeq.charAt(i)) {
                case '>': {
                    continue block3;
                }
                default: {
                    buf.append(charSeq.charAt(i));
                }
            }
        }
        buf.compact();
        return buf;
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qname) throws TransformerException {
        super.startElement("", localName, this.removePrefix(qname));
    }

    @Override
    public void startElement(QName qname) throws TransformerException {
        super.startElement(qname);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws TransformerException {
        super.endElement("", localName, this.removePrefix(qname));
    }

    @Override
    public void endElement(QName qname) throws TransformerException {
        super.endElement(this.removePrefix(qname));
    }

    @Override
    public void namespace(String prefix, String nsURI) throws TransformerException {
    }

    @Override
    public void attribute(String qname, String value) throws TransformerException {
        if (qname != null && !qname.startsWith("xmlns")) {
            super.attribute(this.removePrefix(qname), this.removeRestrictedChars(value).toString());
        }
    }

    @Override
    public void attribute(QName qname, String value) throws TransformerException {
        if (qname != null && (!qname.getLocalPart().startsWith("xmlns") || qname.getPrefix() != null && !qname.getPrefix().startsWith("xmlns"))) {
            super.attribute(this.removePrefix(qname), this.removeRestrictedChars(value).toString());
        }
    }

    @Override
    public void setDefaultNamespace(String namespace) {
    }

    @Override
    public void processingInstruction(String target, String data) throws TransformerException {
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws TransformerException {
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws TransformerException {
    }

    @Override
    public void characters(CharSequence chars) throws TransformerException {
        super.characters(this.removeRestrictedChars(chars));
    }

    @Override
    public void characters(char[] ch, int start, int len) throws TransformerException {
        super.characters(this.removeRestrictedChars(String.valueOf(ch, start, len)));
    }

    @Override
    public void setOutputProperties(Properties properties) {
        properties.setProperty("omit-xml-declaration", "yes");
        super.setOutputProperties(properties);
    }
}

