/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.INodeHandle;
import org.exist.dom.QName;
import org.exist.util.XMLString;
import org.exist.util.serializer.AbstractSerializer;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.XMLWriter;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXSerializer
extends AbstractSerializer
implements ContentHandler,
LexicalHandler,
Receiver {
    private final NamespaceSupport nsSupport = new NamespaceSupport();
    private final Map<String, String> namespaceDecls = new HashMap<String, String>();
    private final Map<String, String> optionalNamespaceDecls = new HashMap<String, String>();
    private boolean enforceXHTML = false;

    public SAXSerializer() {
    }

    public SAXSerializer(Writer writer, Properties outputProperties) {
        this.setOutput(writer, outputProperties);
    }

    @Override
    public final void setOutput(Writer writer, Properties properties) {
        super.setOutput(writer, properties);
        String xhtml = this.outputProperties.getProperty("enforce-xhtml", "no");
        this.enforceXHTML = xhtml.equalsIgnoreCase("yes");
    }

    public Writer getWriter() {
        return this.receiver.getWriter();
    }

    public void setReceiver(XMLWriter receiver) {
        this.receiver = receiver;
    }

    @Override
    public void reset() {
        super.reset();
        this.nsSupport.reset();
        this.namespaceDecls.clear();
        this.optionalNamespaceDecls.clear();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.receiver.startDocument();
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.receiver.endDocument();
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        String ns = this.nsSupport.getURI(prefix);
        if (this.enforceXHTML && !"http://www.w3.org/1999/xhtml".equals(namespaceURI)) {
            namespaceURI = "http://www.w3.org/1999/xhtml";
        }
        if (ns == null || !ns.equals(namespaceURI)) {
            this.optionalNamespaceDecls.put(prefix, namespaceURI);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.optionalNamespaceDecls.remove(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attribs) throws SAXException {
        try {
            String prefix;
            String uri;
            this.namespaceDecls.clear();
            this.nsSupport.pushContext();
            this.receiver.startElement(namespaceURI, localName, qname);
            String elemPrefix = "";
            int p = qname.indexOf(58);
            if (p > 0) {
                elemPrefix = qname.substring(0, p);
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (this.enforceXHTML && elemPrefix.length() == 0 && namespaceURI.length() == 0) {
                namespaceURI = "http://www.w3.org/1999/xhtml";
            }
            if (this.nsSupport.getURI(elemPrefix) == null) {
                this.namespaceDecls.put(elemPrefix, namespaceURI);
                this.nsSupport.declarePrefix(elemPrefix, namespaceURI);
            }
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    String prefix2;
                    String attrName = attribs.getQName(i);
                    if ("xmlns".equals(attrName)) {
                        if (this.nsSupport.getURI("") != null) continue;
                        uri = attribs.getValue(i);
                        if (this.enforceXHTML && !"http://www.w3.org/1999/xhtml".equals(uri)) {
                            uri = "http://www.w3.org/1999/xhtml";
                        }
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        prefix2 = attrName.substring(6);
                        if (this.nsSupport.getURI(prefix2) != null) continue;
                        uri = attribs.getValue(i);
                        this.namespaceDecls.put(prefix2, uri);
                        this.nsSupport.declarePrefix(prefix2, uri);
                        continue;
                    }
                    p = attrName.indexOf(58);
                    if (p <= 0) continue;
                    prefix2 = attrName.substring(0, p);
                    uri = attribs.getURI(i);
                    if (this.nsSupport.getURI(prefix2) != null) continue;
                    this.namespaceDecls.put(prefix2, uri);
                    this.nsSupport.declarePrefix(prefix2, uri);
                }
            }
            for (Map.Entry<String, String> nsEntry : this.optionalNamespaceDecls.entrySet()) {
                prefix = nsEntry.getKey();
                uri = nsEntry.getValue();
                this.receiver.namespace(prefix, uri);
                this.nsSupport.declarePrefix(prefix, uri);
            }
            for (Map.Entry<String, String> nsEntry : this.namespaceDecls.entrySet()) {
                prefix = nsEntry.getKey();
                uri = nsEntry.getValue();
                if (this.optionalNamespaceDecls.containsKey(prefix)) continue;
                this.receiver.namespace(prefix, uri);
            }
            if ("".equals(elemPrefix) && !namespaceURI.equals(this.receiver.getDefaultNamespace())) {
                this.receiver.namespace("", namespaceURI);
                this.nsSupport.declarePrefix("", namespaceURI);
            }
            this.optionalNamespaceDecls.clear();
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    if (attribs.getQName(i).startsWith("xmlns")) continue;
                    this.receiver.attribute(attribs.getQName(i), attribs.getValue(i));
                }
            }
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(QName qname, AttrList attribs) throws SAXException {
        try {
            String uri;
            this.namespaceDecls.clear();
            this.nsSupport.pushContext();
            String prefix = qname.getPrefix();
            String namespaceURI = qname.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (this.enforceXHTML && prefix.length() == 0 && namespaceURI.length() == 0) {
                namespaceURI = "http://www.w3.org/1999/xhtml";
                this.receiver.startElement(new QName(qname.getLocalPart(), namespaceURI, qname.getPrefix()));
            } else {
                this.receiver.startElement(qname);
            }
            if (this.nsSupport.getURI(prefix) == null) {
                this.namespaceDecls.put(prefix, namespaceURI);
                this.nsSupport.declarePrefix(prefix, namespaceURI);
            }
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    QName attrQName = attribs.getQName(i);
                    if ("xmlns".equals(attrQName.getLocalPart())) {
                        if (this.nsSupport.getURI("") != null) continue;
                        uri = attribs.getValue(i);
                        if (this.enforceXHTML && !"http://www.w3.org/1999/xhtml".equals(uri)) {
                            uri = "http://www.w3.org/1999/xhtml";
                        }
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrQName.getPrefix() == null || attrQName.getPrefix().length() <= 0 || this.nsSupport.getURI(prefix = attrQName.getPrefix()) != null) continue;
                    uri = attrQName.getNamespaceURI();
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
            }
            for (Map.Entry<String, String> nsEntry : this.optionalNamespaceDecls.entrySet()) {
                String optPrefix = nsEntry.getKey();
                uri = nsEntry.getValue();
                this.receiver.namespace(optPrefix, uri);
                this.nsSupport.declarePrefix(optPrefix, uri);
            }
            for (Map.Entry<String, String> nsEntry : this.namespaceDecls.entrySet()) {
                String optPrefix = nsEntry.getKey();
                if ("xmlns".equals(optPrefix)) continue;
                uri = nsEntry.getValue();
                if (this.optionalNamespaceDecls.containsKey(optPrefix)) continue;
                this.receiver.namespace(optPrefix, uri);
            }
            this.optionalNamespaceDecls.clear();
            if ("".equals(prefix) && !namespaceURI.equals(this.receiver.getDefaultNamespace())) {
                this.receiver.namespace("", namespaceURI);
                this.nsSupport.declarePrefix("", namespaceURI);
            }
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    if (attribs.getQName(i).getLocalPart().startsWith("xmlns")) continue;
                    this.receiver.attribute(attribs.getQName(i), attribs.getValue(i));
                }
            }
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        try {
            this.nsSupport.popContext();
            this.receiver.endElement(namespaceURI, localName, qname);
            this.receiver.setDefaultNamespace(this.nsSupport.getURI(""));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(QName qname) throws SAXException {
        try {
            this.nsSupport.popContext();
            String prefix = qname.getPrefix();
            String namespaceURI = qname.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (this.enforceXHTML && prefix.length() == 0 && namespaceURI.length() == 0) {
                namespaceURI = "http://www.w3.org/1999/xhtml";
                this.receiver.endElement(new QName(qname.getLocalPart(), namespaceURI, qname.getPrefix()));
            } else {
                this.receiver.endElement(qname);
            }
            this.receiver.setDefaultNamespace(this.nsSupport.getURI(""));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void attribute(QName qname, String value) throws SAXException {
        if (qname.getPrefix() != null && "xmlns".equals(qname.getPrefix()) || "xmlns".equals(qname.getLocalPart())) {
            return;
        }
        try {
            this.receiver.attribute(qname, value);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.characters(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void characters(CharSequence seq) throws SAXException {
        try {
            this.receiver.characters(seq);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.characters(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.receiver.processingInstruction(target, data);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.cdataSection(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws SAXException {
        try {
            this.receiver.documentType(name, publicId, systemId);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void highlightText(CharSequence seq) {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.comment(new XMLString(ch, start, len));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void setCurrentNode(INodeHandle node) {
    }

    @Override
    public Document getDocument() {
        return null;
    }
}

