/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import org.exist.dom.QName;
import org.exist.util.XMLString;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXToReceiver
implements ContentHandler,
LexicalHandler {
    private Receiver receiver;
    private boolean inCDATASection = false;
    private boolean suppressWhitespace = true;

    public SAXToReceiver(Receiver receiver) {
        this(receiver, false);
    }

    public SAXToReceiver(Receiver receiver, boolean suppressWhitespace) {
        this.receiver = receiver;
        this.suppressWhitespace = suppressWhitespace;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.receiver.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.receiver.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.receiver.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.receiver.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String prefix = null;
        int p = qName.indexOf(58);
        if (p > -1) {
            prefix = qName.substring(0, p - 1);
        }
        AttrList attrs = new AttrList();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).startsWith("xmlns")) continue;
            String attrPrefix = null;
            p = atts.getQName(i).indexOf(58);
            if (p > -1) {
                attrPrefix = atts.getQName(i).substring(0, p - 1);
            }
            int type = 0;
            String atype = atts.getType(i);
            if ("ID".equals(atype)) {
                type = 1;
            } else if ("IDREF".equals(atype)) {
                type = 2;
            } else if ("IDREFS".equals(atype)) {
                type = 3;
            }
            attrs.addAttribute(new QName(atts.getLocalName(i), atts.getURI(i), attrPrefix), atts.getValue(i), type);
        }
        this.receiver.startElement(new QName(localName, uri, prefix), attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String prefix = null;
        int p = qName.indexOf(58);
        if (p > -1) {
            prefix = qName.substring(0, p - 1);
        }
        this.receiver.endElement(new QName(localName, uri, prefix));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inCDATASection) {
            this.receiver.cdataSection(ch, start, length);
        } else {
            this.receiver.characters(new XMLString(ch, start, length));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.suppressWhitespace) {
            this.receiver.characters(new XMLString(ch, start, length));
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.receiver.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.inCDATASection = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.inCDATASection = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.receiver.comment(ch, start, length);
    }
}

