/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.Properties;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.AdaptiveSerializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.util.serializer.json.JSONSerializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XQuerySerializer {
    private final Properties outputProperties;
    private final DBBroker broker;
    private final Writer writer;

    public XQuerySerializer(DBBroker broker, Properties outputProperties, Writer writer) {
        this.broker = broker;
        this.outputProperties = outputProperties;
        this.writer = writer;
    }

    public void serialize(Sequence sequence) throws SAXException, XPathException {
        this.serialize(sequence, 1, sequence.getItemCount(), false, false, 0L, 0L);
    }

    public void serialize(Sequence sequence, int start, int howmany, boolean wrap, boolean typed, long compilationTime, long executionTime) throws SAXException, XPathException {
        String method;
        switch (method = this.outputProperties.getProperty("method", "xml")) {
            case "adaptive": {
                this.serializeAdaptive(sequence);
                break;
            }
            case "json": {
                this.serializeJSON(sequence, compilationTime, executionTime);
                break;
            }
            default: {
                this.serializeXML(sequence, start, howmany, wrap, typed, compilationTime, executionTime);
            }
        }
    }

    public boolean normalize() {
        String method = this.outputProperties.getProperty("method", "xml");
        return !"json".equals(method) && !"adaptive".equals(method);
    }

    private void serializeXML(Sequence sequence, int start, int howmany, boolean wrap, boolean typed, long compilationTime, long executionTime) throws SAXException, XPathException {
        Serializer serializer = this.broker.getSerializer();
        serializer.reset();
        SAXSerializer sax = null;
        try {
            sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            sax.setOutput(this.writer, this.outputProperties);
            serializer.setProperties(this.outputProperties);
            serializer.setSAXHandlers(sax, sax);
            serializer.toSAX(sequence, start, howmany, wrap, typed, compilationTime, executionTime);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            if (sax != null) {
                SerializerPool.getInstance().returnObject(sax);
            }
        }
    }

    private void serializeJSON(Sequence sequence, long compilationTime, long executionTime) throws SAXException, XPathException {
        if (sequence.hasOne() && Type.subTypeOf(sequence.getItemType(), 1)) {
            this.serializeXML(sequence, 1, sequence.getItemCount(), false, false, compilationTime, executionTime);
        } else {
            JSONSerializer serializer = new JSONSerializer(this.broker, this.outputProperties);
            serializer.serialize(sequence, this.writer);
        }
    }

    private void serializeAdaptive(Sequence sequence) throws SAXException, XPathException {
        AdaptiveSerializer serializer = new AdaptiveSerializer(this.broker);
        serializer.setOutput(this.writer, this.outputProperties);
        serializer.serialize(sequence);
    }
}

