/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import java.io.IOException;
import java.io.Writer;

public abstract class JSONNode {
    protected static final String ANONYMOUS_OBJECT = "#anonymous";
    private Type type;
    private String name;
    private SerializationType serializationType = SerializationType.AS_OBJECT;
    private SerializationDataType serializationDataType = SerializationDataType.AS_STRING;
    private boolean indent = false;
    private JSONNode next = null;
    private JSONNode nextOfSame = null;

    public JSONNode(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public abstract void serialize(Writer var1, boolean var2) throws IOException;

    public abstract void serializeContent(Writer var1) throws IOException;

    public Type getType() {
        return this.type;
    }

    public boolean isNamed() {
        return !this.getName().equals(ANONYMOUS_OBJECT);
    }

    public boolean isArray() {
        return this.getNextOfSame() != null || this.getSerializationType() == SerializationType.AS_ARRAY;
    }

    public SerializationType getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(SerializationType serializationType) {
        this.serializationType = serializationType;
    }

    public SerializationDataType getSerializationDataType() {
        return this.serializationDataType;
    }

    public void setSerializationDataType(SerializationDataType serializationDataType) {
        this.serializationDataType = serializationDataType;
    }

    public JSONNode getNextOfSame() {
        return this.nextOfSame;
    }

    public void setNextOfSame(JSONNode nextOfSame) {
        if (this.nextOfSame == null) {
            this.nextOfSame = nextOfSame;
        } else {
            JSONNode current = this.nextOfSame;
            while (current.nextOfSame != null) {
                current = current.nextOfSame;
            }
            current.nextOfSame = nextOfSame;
        }
    }

    public void setNext(JSONNode next) {
        this.next = next;
    }

    public JSONNode getNext() {
        return this.next;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public static enum Type {
        OBJECT_TYPE,
        VALUE_TYPE,
        SIMPLE_PROPERTY_TYPE;

    }

    public static enum SerializationDataType {
        AS_STRING,
        AS_LITERAL;

    }

    public static enum SerializationType {
        AS_OBJECT,
        AS_ARRAY;

    }
}

