/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class JSONSerializer {
    private final DBBroker broker;
    private final Properties outputProperties;

    public JSONSerializer(DBBroker broker, Properties outputProperties) {
        this.broker = broker;
        this.outputProperties = outputProperties;
    }

    public void serialize(Sequence sequence, Writer writer) throws SAXException {
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(writer);
            generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            if ("yes".equals(this.outputProperties.getProperty("indent", "no"))) {
                generator.useDefaultPrettyPrinter();
            }
            if ("yes".equals(this.outputProperties.getProperty("allow-duplicate-names", "yes"))) {
                generator.enable(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION);
            } else {
                generator.disable(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION);
            }
            this.serializeSequence(sequence, generator);
            generator.close();
        }
        catch (IOException | XPathException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void serializeSequence(Sequence sequence, JsonGenerator generator) throws IOException, XPathException, SAXException {
        if (sequence.isEmpty()) {
            generator.writeNull();
        } else if (sequence.hasOne() && "no".equals(this.outputProperties.getProperty("json-array-output", "no"))) {
            this.serializeItem(sequence.itemAt(0), generator);
        } else {
            generator.writeStartArray();
            SequenceIterator i = sequence.iterate();
            while (i.hasNext()) {
                this.serializeItem(i.nextItem(), generator);
            }
            generator.writeEndArray();
        }
    }

    private void serializeItem(Item item, JsonGenerator generator) throws IOException, XPathException, SAXException {
        if (item.getType() == 103) {
            this.serializeArray((ArrayType)item, generator);
        } else if (item.getType() == 102) {
            this.serializeMap((MapType)item, generator);
        } else if (Type.subTypeOf(item.getType(), 20)) {
            if (Type.subTypeOf(item.getType(), 30)) {
                generator.writeNumber(item.getStringValue());
            } else {
                switch (item.getType()) {
                    case 23: {
                        generator.writeBoolean(((AtomicValue)item).effectiveBooleanValue());
                        break;
                    }
                    default: {
                        generator.writeString(item.getStringValue());
                        break;
                    }
                }
            }
        } else if (Type.subTypeOf(item.getType(), -1)) {
            this.serializeNode(item, generator);
        }
    }

    private void serializeNode(Item item, JsonGenerator generator) throws SAXException {
        Serializer serializer = this.broker.getSerializer();
        serializer.reset();
        Properties xmlOutput = new Properties();
        xmlOutput.setProperty("method", this.outputProperties.getProperty("json-node-output-method", "xml"));
        xmlOutput.setProperty("omit-xml-declaration", "yes");
        xmlOutput.setProperty("indent", this.outputProperties.getProperty("indent", "no"));
        try {
            serializer.setProperties(xmlOutput);
            generator.writeString(serializer.serialize((NodeValue)item));
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void serializeArray(ArrayType array, JsonGenerator generator) throws IOException, XPathException, SAXException {
        generator.writeStartArray();
        for (int i = 0; i < array.getSize(); ++i) {
            Sequence member = array.get(i);
            this.serializeSequence(member, generator);
        }
        generator.writeEndArray();
    }

    private void serializeMap(MapType map, JsonGenerator generator) throws IOException, XPathException, SAXException {
        generator.writeStartObject();
        for (Map.Entry<AtomicValue, Sequence> entry : map) {
            generator.writeFieldName(entry.getKey().getStringValue());
            this.serializeSequence(entry.getValue(), generator);
        }
        generator.writeEndObject();
    }
}

