/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import java.io.IOException;
import java.io.Writer;
import org.exist.util.serializer.json.JSONNode;
import org.exist.util.serializer.json.JSONValue;

public class JSONSimpleProperty
extends JSONNode {
    private final String value;

    public JSONSimpleProperty(String name, String value) {
        this(name, value, false);
    }

    public JSONSimpleProperty(String name, String value, boolean isLiteral) {
        super(JSONNode.Type.SIMPLE_PROPERTY_TYPE, name);
        this.value = JSONValue.escape(value);
        if (isLiteral) {
            this.setSerializationDataType(JSONNode.SerializationDataType.AS_LITERAL);
        }
    }

    @Override
    public void serialize(Writer writer, boolean isRoot) throws IOException {
        writer.write(34);
        writer.write(this.getName());
        writer.write("\"");
        if (this.isIndent()) {
            writer.write(32);
        }
        writer.write(58);
        if (this.isIndent()) {
            writer.write(32);
        }
        if (this.getSerializationDataType() != JSONNode.SerializationDataType.AS_LITERAL) {
            writer.write(34);
        }
        writer.write(this.value);
        if (this.getSerializationDataType() != JSONNode.SerializationDataType.AS_LITERAL) {
            writer.write(34);
        }
    }

    @Override
    public void serializeContent(Writer writer) throws IOException {
    }
}

