/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.serializer.XMLWriter;
import org.exist.util.serializer.json.JSONNode;
import org.exist.util.serializer.json.JSONObject;
import org.exist.util.serializer.json.JSONSimpleProperty;
import org.exist.util.serializer.json.JSONValue;

public class JSONWriter
extends XMLWriter {
    private static final Logger LOG = LogManager.getLogger(JSONWriter.class);
    private static final String ARRAY = "array";
    private static final String LITERAL = "literal";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String JSON_ARRAY = "json:array";
    private static final String JSON_LITERAL = "json:literal";
    private static final String JSON_VALUE = "json:value";
    private static final String JSON_NAME = "json:name";
    public static final String JASON_NS = "http://www.json.org";
    protected JSONNode root;
    protected final Deque<JSONObject> stack = new ArrayDeque<JSONObject>();
    protected boolean useNSPrefix = false;
    protected boolean prefixAttributes = false;
    protected boolean ignoreWhitespaceTextNodes = false;
    private String jsonp = null;
    private boolean indent = false;

    public JSONWriter() {
    }

    public JSONWriter(Writer writer) {
        super(writer);
    }

    @Override
    protected void resetObjectState() {
        super.resetObjectState();
        this.stack.clear();
        this.root = null;
    }

    @Override
    public void setOutputProperties(Properties properties) {
        super.setOutputProperties(properties);
        String useNSPrefixProp = properties.getProperty("preserve-prefix", "no");
        this.useNSPrefix = useNSPrefixProp.equalsIgnoreCase("yes");
        String prefixAttributesProp = properties.getProperty("prefix-attributes", "no");
        this.prefixAttributes = prefixAttributesProp.equalsIgnoreCase("yes");
        String ignoreWhitespaceTextNodesProp = properties.getProperty("json-ignore-whitespace-text-nodes", "no");
        this.ignoreWhitespaceTextNodes = ignoreWhitespaceTextNodesProp.equalsIgnoreCase("yes");
        this.jsonp = properties.getProperty("jsonp");
        this.indent = properties.getProperty("indent", "no").equalsIgnoreCase("yes");
    }

    @Override
    public void startDocument() throws TransformerException {
    }

    @Override
    public void endDocument() throws TransformerException {
        try {
            if (this.root != null) {
                if (this.jsonp != null) {
                    this.getWriter().write(this.jsonp + "(");
                }
                this.root.serialize(this.getWriter(), true);
                if (this.jsonp != null) {
                    this.getWriter().write(")");
                }
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname) throws TransformerException {
        if (qname.equals(JSON_VALUE)) {
            this.processStartValue();
        } else if (this.useNSPrefix) {
            this.processStartElement(qname.replace(':', '_'), false);
        } else {
            try {
                this.processStartElement(QName.extractLocalName(qname), false);
            }
            catch (QName.IllegalQNameException e) {
                throw new TransformerException(e);
            }
        }
    }

    @Override
    public void startElement(QName qname) throws TransformerException {
        if (JASON_NS.equals(qname.getNamespaceURI()) && VALUE.equals(qname.getLocalPart())) {
            this.processStartValue();
        } else if (this.useNSPrefix) {
            this.processStartElement(qname.getPrefix() + '_' + qname.getLocalPart(), false);
        } else {
            this.processStartElement(qname.getLocalPart(), false);
        }
    }

    private void processStartElement(String localName, boolean simpleValue) {
        JSONObject obj = new JSONObject(localName);
        obj.setIndent(this.indent);
        if (this.root == null) {
            this.root = obj;
            this.stack.push(obj);
        } else {
            JSONObject parent = this.stack.peek();
            parent.addObject(obj);
            this.stack.push(obj);
        }
    }

    private void processStartValue() throws TransformerException {
        JSONObject obj = new JSONObject();
        obj.setIndent(this.indent);
        if (this.root == null) {
            this.root = obj;
            this.stack.push(obj);
        } else {
            JSONObject parent = this.stack.peek();
            parent.addObject(obj);
            this.stack.push(obj);
        }
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qname) throws TransformerException {
        this.stack.pop();
    }

    @Override
    public void endElement(QName qname) throws TransformerException {
        this.stack.pop();
    }

    @Override
    public void namespace(String prefix, String nsURI) throws TransformerException {
    }

    @Override
    public void attribute(String qname, String value) throws TransformerException {
        JSONObject parent = this.stack.peek();
        switch (qname) {
            case "json:array": {
                parent.setSerializationType(JSONNode.SerializationType.AS_ARRAY);
                break;
            }
            case "json:literal": {
                parent.setSerializationDataType(JSONNode.SerializationDataType.AS_LITERAL);
                break;
            }
            case "json:name": {
                parent.setName(value);
                break;
            }
            default: {
                String name = this.prefixAttributes ? "@" + qname : qname;
                JSONSimpleProperty obj = new JSONSimpleProperty(name, value);
                obj.setIndent(this.indent);
                parent.addObject(obj);
            }
        }
    }

    @Override
    public void attribute(QName qname, String value) throws TransformerException {
        this.attribute(qname.toString(), value);
    }

    @Override
    public void characters(CharSequence chars) throws TransformerException {
        boolean isWhitespace;
        if (this.ignoreWhitespaceTextNodes && (isWhitespace = chars.toString().trim().isEmpty())) {
            return;
        }
        JSONObject parent = this.stack.peek();
        JSONValue value = new JSONValue(chars.toString());
        value.setIndent(this.indent);
        value.setSerializationType(parent.getSerializationType());
        value.setSerializationDataType(parent.getSerializationDataType());
        parent.addObject(value);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws TransformerException {
        this.characters(new String(ch, start, len));
    }

    @Override
    public void processingInstruction(String target, String data) throws TransformerException {
    }

    @Override
    public void comment(CharSequence data) throws TransformerException {
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws TransformerException {
        this.characters(ch, start, len);
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws TransformerException {
    }
}

