/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class GrammarPool
implements XMLGrammarPool {
    private static final Logger logger = LogManager.getLogger(GrammarPool.class);
    private final XMLGrammarPool pool;

    public GrammarPool() {
        if (logger.isInfoEnabled()) {
            logger.info("Initializing GrammarPool.");
        }
        this.pool = new XMLGrammarPoolImpl();
    }

    public GrammarPool(XMLGrammarPool pool) {
        if (logger.isInfoEnabled()) {
            logger.info("Initializing GrammarPool using supplied pool.");
        }
        this.pool = pool;
    }

    public Grammar[] retrieveInitialGrammarSet(String type) {
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieve initial grammarset (" + type + ").");
        }
        Grammar[] grammars = this.pool.retrieveInitialGrammarSet(type);
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + grammars.length + " grammars.");
        }
        return grammars;
    }

    public void cacheGrammars(String type, Grammar[] grammar) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cache " + grammar.length + " grammars (" + type + ").");
        }
        this.pool.cacheGrammars(type, grammar);
    }

    public void unlockPool() {
        if (logger.isDebugEnabled()) {
            logger.debug("Unlock grammarpool.");
        }
        this.pool.unlockPool();
    }

    public Grammar retrieveGrammar(XMLGrammarDescription xgd) {
        if (xgd == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("XMLGrammarDescription is null");
            }
            return null;
        }
        if (xgd.getNamespace() != null && logger.isDebugEnabled()) {
            logger.debug("Retrieve grammar for namespace '" + xgd.getNamespace() + "'.");
        }
        if (xgd.getPublicId() != null && logger.isDebugEnabled()) {
            logger.debug("Retrieve grammar for publicId '" + xgd.getPublicId() + "'.");
        }
        return this.pool.retrieveGrammar(xgd);
    }

    public void lockPool() {
        if (logger.isDebugEnabled()) {
            logger.debug("Lock grammarpool.");
        }
        this.pool.lockPool();
    }

    public void clear() {
        if (logger.isDebugEnabled()) {
            logger.debug("Clear grammarpool.");
        }
        this.pool.clear();
    }

    public void clearDTDs() {
        Grammar[] dtds = this.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        if (dtds.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removing " + dtds.length + " DTDs.");
            }
            Grammar[] schemas = this.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            this.clear();
            this.cacheGrammars("http://www.w3.org/2001/XMLSchema", schemas);
        }
    }
}

