/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.ExistSAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlLibraryChecker {
    private static final ClassVersion[] validParsers = new ClassVersion[]{new ClassVersion("Xerces", "Xerces-J 2.10.0", "org.apache.xerces.impl.Version.getVersion()")};
    private static final ClassVersion[] validTransformers = new ClassVersion[]{new ClassVersion("Saxon", "8.9.0", "net.sf.saxon.Version.getProductVersion()"), new ClassVersion("Xalan", "Xalan Java 2.7.1", "org.apache.xalan.Version.getVersion()")};
    private static final ClassVersion[] validResolvers = new ClassVersion[]{new ClassVersion("Resolver", "XmlResolver 1.2", "org.apache.xml.resolver.Version.getVersion()")};
    private static final Logger logger = LogManager.getLogger(XmlLibraryChecker.class);

    private static String getClassName(String classid) {
        int lastChar = classid.lastIndexOf(64);
        String className = lastChar == -1 ? classid : classid.substring(0, lastChar);
        return className;
    }

    private static String determineActualParserClass() {
        String parserClass = "Unable to determine parser class";
        try {
            SAXParserFactory factory = ExistSAXParserFactory.getSAXParserFactory();
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            String classId = xmlReader.toString();
            parserClass = XmlLibraryChecker.getClassName(classId);
        }
        catch (ParserConfigurationException | SAXException ex) {
            logger.error(ex.getMessage());
        }
        return parserClass;
    }

    private static String determineActualTransformerClass() {
        String transformerClass = "Unable to determine transformer class";
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            String classId = transformer.toString();
            transformerClass = XmlLibraryChecker.getClassName(classId);
        }
        catch (TransformerConfigurationException ex) {
            logger.error(ex.getMessage());
        }
        return transformerClass;
    }

    public static void check() {
        StringBuilder message = new StringBuilder();
        ServiceLoader<SAXParserFactory> allSax = ServiceLoader.load(SAXParserFactory.class);
        for (SAXParserFactory sax : allSax) {
            message.append(XmlLibraryChecker.getClassName(sax.toString()));
            message.append(" ");
        }
        logger.debug("Detected SAXParserFactory classes: " + message.toString());
        message = new StringBuilder();
        boolean invalidVersionFound = false;
        if (XmlLibraryChecker.hasValidClassVersion("Parser", validParsers, message)) {
            logger.info(message.toString());
        } else {
            logger.warn(message.toString());
            invalidVersionFound = true;
        }
        message = new StringBuilder();
        ServiceLoader<TransformerFactory> allXsl = ServiceLoader.load(TransformerFactory.class);
        for (TransformerFactory xsl : allXsl) {
            message.append(XmlLibraryChecker.getClassName(xsl.toString()));
            message.append(" ");
        }
        logger.debug("Detected TransformerFactory classes: " + message.toString());
        message = new StringBuilder();
        if (XmlLibraryChecker.hasValidClassVersion("Transformer", validTransformers, message)) {
            logger.info(message.toString());
        } else {
            logger.warn(message.toString());
            System.err.println(message.toString());
            invalidVersionFound = true;
        }
        message = new StringBuilder();
        if (XmlLibraryChecker.hasValidClassVersion("Resolver", validResolvers, message)) {
            logger.info(message.toString());
        } else {
            logger.warn(message.toString());
            invalidVersionFound = true;
        }
        logger.info("Using parser " + XmlLibraryChecker.determineActualParserClass());
        logger.info("Using transformer " + XmlLibraryChecker.determineActualTransformerClass());
        if (invalidVersionFound) {
            logger.warn("Using parser " + XmlLibraryChecker.determineActualParserClass());
            logger.warn("Using transformer " + XmlLibraryChecker.determineActualTransformerClass());
        }
    }

    public static boolean hasValidClassVersion(String type, ClassVersion[] validClasses, StringBuilder message) {
        String sep = System.getProperty("line.separator");
        message.append("Looking for a valid ").append(type).append("...").append(sep);
        for (ClassVersion validClass : validClasses) {
            String actualVersion = validClass.getActualVersion();
            message.append("Checking for ").append(validClass.getSimpleName());
            if (actualVersion != null) {
                message.append(", found version ").append(actualVersion);
                if (actualVersion.compareToIgnoreCase(validClass.getRequiredVersion()) >= 0) {
                    message.append(sep).append("OK!").append(sep);
                    return true;
                }
                message.append(" needed version ").append(validClass.getRequiredVersion()).append(sep);
                continue;
            }
            message.append(", not found!").append(sep);
        }
        message.append("Warning: Failed find a valid ").append(type).append("!").append(sep);
        message.append(sep).append("Please add an appropriate ").append(type).append(" to the class-path, e.g. in the 'endorsed' folder of the servlet container or in the 'endorsed' folder of the JRE.").append(sep);
        return false;
    }

    public static boolean hasValidParser() {
        return XmlLibraryChecker.hasValidParser(new StringBuilder());
    }

    public static boolean hasValidParser(StringBuilder message) {
        return XmlLibraryChecker.hasValidClassVersion("Parser", validParsers, message);
    }

    public static boolean hasValidTransformer() {
        return XmlLibraryChecker.hasValidTransformer(new StringBuilder());
    }

    public static boolean hasValidTransformer(StringBuilder message) {
        return XmlLibraryChecker.hasValidClassVersion("Transformer", validTransformers, message);
    }

    public static class ClassVersion {
        private final String simpleName;
        private final String requiredVersion;
        private final String versionFunction;

        ClassVersion(String simpleName, String requiredVersion, String versionFunction) {
            this.simpleName = simpleName;
            this.requiredVersion = requiredVersion;
            this.versionFunction = versionFunction;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getRequiredVersion() {
            return this.requiredVersion;
        }

        public String getActualVersion() {
            String actualVersion = null;
            String versionClassName = this.versionFunction.substring(0, this.versionFunction.lastIndexOf(46));
            String versionFunctionName = this.versionFunction.substring(this.versionFunction.lastIndexOf(46) + 1, this.versionFunction.lastIndexOf(40));
            try {
                Class<?> versionClass = Class.forName(versionClassName);
                Method getVersionMethod = versionClass.getMethod(versionFunctionName, null);
                actualVersion = (String)getVersionMethod.invoke(versionClass, (Object[])null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.debug(ex.getMessage());
            }
            return actualVersion;
        }
    }
}

