/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.ClassLoaderSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DatabaseResources {
    public static final String QUERY_LOCATION = "org/exist/validation/internal/query/";
    public static final String FIND_XSD = "org/exist/validation/internal/query/find_schema_by_targetNamespace.xq";
    public static final String FIND_CATALOGS_WITH_DTD = "org/exist/validation/internal/query/find_catalogs_with_dtd.xq";
    public static final String PUBLICID = "publicId";
    public static final String TARGETNAMESPACE = "targetNamespace";
    public static final String CATALOG = "catalog";
    public static final String COLLECTION = "collection";
    private BrokerPool brokerPool = null;
    private static final Logger logger = LogManager.getLogger(DatabaseResources.class);

    public List<String> getAllResults(Sequence sequence) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            SequenceIterator i = sequence.iterate();
            while (i.hasNext()) {
                String path = i.nextItem().getStringValue();
                result.add(path);
            }
        }
        catch (XPathException ex) {
            logger.error("xQuery issue.", (Throwable)ex);
            result = null;
        }
        return result;
    }

    public String getFirstResult(Sequence sequence) {
        String result = null;
        try {
            SequenceIterator i = sequence.iterate();
            if (i.hasNext()) {
                result = i.nextItem().getStringValue();
                logger.debug("Single query result: '" + result + "'.");
            } else {
                logger.debug("No query result.");
            }
        }
        catch (XPathException ex) {
            logger.error("xQuery issue ", (Throwable)ex);
        }
        return result;
    }

    public Sequence executeQuery(String queryPath, Map<String, String> params, Subject user) {
        String namespace = params.get(TARGETNAMESPACE);
        String publicId = params.get(PUBLICID);
        String catalogPath = params.get(CATALOG);
        String collection = params.get(COLLECTION);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("collection=%s namespace=%s publicId=%s catalogPath=%s", collection, namespace, publicId, catalogPath));
        }
        Sequence result = null;
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(user));){
            XQuery xquery = this.brokerPool.getXQueryService();
            XQueryContext context = new XQueryContext(this.brokerPool);
            if (collection != null) {
                context.declareVariable(COLLECTION, (Object)collection);
            }
            if (namespace != null) {
                context.declareVariable(TARGETNAMESPACE, (Object)namespace);
            }
            if (publicId != null) {
                context.declareVariable(PUBLICID, (Object)publicId);
            }
            if (catalogPath != null) {
                context.declareVariable(CATALOG, (Object)catalogPath);
            }
            CompiledXQuery compiled = xquery.compile(broker, context, new ClassLoaderSource(queryPath));
            result = xquery.execute(broker, compiled, null);
        }
        catch (IOException | EXistException | PermissionDeniedException | XPathException ex) {
            logger.error("Problem executing xquery", (Throwable)ex);
            result = null;
        }
        return result;
    }

    public DatabaseResources(BrokerPool pool) {
        logger.info("Initializing DatabaseResources");
        this.brokerPool = pool;
    }

    public String findXSD(String collection, String targetNamespace, Subject user) {
        if (logger.isDebugEnabled()) {
            logger.debug("Find schema with namespace '" + targetNamespace + "' in '" + collection + "'.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COLLECTION, collection);
        params.put(TARGETNAMESPACE, targetNamespace);
        Sequence result = this.executeQuery(FIND_XSD, params, user);
        return this.getFirstResult(result);
    }

    public String findCatalogWithDTD(String collection, String publicId, Subject user) {
        if (logger.isDebugEnabled()) {
            logger.debug("Find DTD with public '" + publicId + "' in '" + collection + "'.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COLLECTION, collection);
        params.put(PUBLICID, publicId);
        Sequence result = this.executeQuery(FIND_CATALOGS_WITH_DTD, params, user);
        return this.getFirstResult(result);
    }
}

