/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal.node;

import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.io.BlockingInputStream;
import org.exist.storage.io.BlockingOutputStream;
import org.exist.storage.serializers.Serializer;
import org.exist.validation.internal.node.NodeSerializerThread;
import org.exist.xquery.value.NodeValue;

public class NodeInputStream
extends InputStream {
    private static final Logger logger = LogManager.getLogger(NodeInputStream.class);
    private final BlockingInputStream bis;

    public NodeInputStream(Serializer serializer, NodeValue node) {
        logger.debug("Initializing NodeInputStream");
        this.bis = new BlockingInputStream();
        BlockingOutputStream bos = this.bis.getOutputStream();
        NodeSerializerThread rt = new NodeSerializerThread(serializer, node, bos);
        rt.start();
        logger.debug("Initializing NodeInputStream done");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bis.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.bis.reset();
    }

    @Override
    public int read() throws IOException {
        return this.bis.read();
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }
}

