/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal.node;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.value.NodeValue;
import org.xml.sax.SAXException;

public class NodeSerializer {
    private static final Logger LOG = LogManager.getLogger(NodeSerializer.class);

    public static void serialize(Serializer serializer, NodeValue node, Properties outputProperties, OutputStream os) throws IOException {
        LOG.debug("Serializing started.");
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        try {
            String encoding = outputProperties.getProperty("encoding", "UTF-8");
            try (OutputStreamWriter writer = new OutputStreamWriter(os, encoding);){
                sax.setOutput(writer, outputProperties);
                serializer.reset();
                serializer.setProperties(outputProperties);
                serializer.setSAXHandlers(sax, sax);
                sax.startDocument();
                serializer.toSAX(node);
                sax.endDocument();
            }
        }
        catch (IOException | SAXException e) {
            String txt = "A problem occurred while serializing the node set";
            LOG.debug("A problem occurred while serializing the node set.", (Throwable)e);
            throw new IOException("A problem occurred while serializing the node set: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("Serializing done.");
            SerializerPool.getInstance().returnObject(sax);
        }
    }
}

