/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal.node;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.io.BlockingOutputStream;
import org.exist.storage.serializers.Serializer;
import org.exist.validation.internal.node.NodeSerializer;
import org.exist.xquery.value.NodeValue;

public class NodeSerializerThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(NodeSerializerThread.class);
    private final Serializer serializer;
    private final NodeValue node;
    private final BlockingOutputStream bos;
    private static final AtomicLong nodeSerializerThreadId = new AtomicLong();

    public NodeSerializerThread(Serializer serializer, NodeValue node, BlockingOutputStream bos) {
        super("exist-nodeSerializerThread-" + nodeSerializerThreadId.getAndIncrement());
        this.serializer = serializer;
        this.node = node;
        this.bos = bos;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block10: {
            IOException exception = null;
            Properties outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            outputProperties.setProperty("omit-xml-declaration", "yes");
            NodeSerializer.serialize(this.serializer, this.node, outputProperties, this.bos);
            try {
                this.bos.close(exception);
            }
            catch (IOException ex) {
                logger.debug((Object)ex);
            }
            break block10;
            catch (IOException ex) {
                try {
                    logger.error((Object)ex);
                    exception = ex;
                }
                catch (Throwable throwable) {
                    try {
                        this.bos.close(exception);
                    }
                    catch (IOException ex2) {
                        logger.debug((Object)ex2);
                    }
                    throw throwable;
                }
                try {
                    this.bos.close(exception);
                }
                catch (IOException ex3) {
                    logger.debug((Object)ex3);
                }
            }
        }
    }
}

