/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcInputStream;

public class AnyUriResolver
implements XMLEntityResolver {
    private static final Logger LOG = LogManager.getLogger(AnyUriResolver.class);
    private String docPath;
    private final String parentURI;
    private boolean firstTime = true;

    public AnyUriResolver(String path) {
        this.docPath = path;
        if (this.docPath.startsWith("/")) {
            this.docPath = "xmldb:exist://" + this.docPath;
        }
        LOG.debug("Specified path=" + path);
        if (path.lastIndexOf(47) != -1) {
            this.parentURI = path.substring(0, path.lastIndexOf(47));
            LOG.debug("parentURI=" + this.parentURI);
        } else {
            this.parentURI = "";
        }
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        XmldbURL xmldbURL;
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri));
        }
        String resourcePath = null;
        String baseSystemId = null;
        if (this.firstTime) {
            resourcePath = this.docPath;
            baseSystemId = this.parentURI;
            xri.setExpandedSystemId(this.docPath);
            this.firstTime = false;
        } else {
            resourcePath = xri.getExpandedSystemId();
        }
        xri.setBaseSystemId(this.docPath);
        LOG.debug("resourcePath='" + resourcePath + "'");
        if (resourcePath == null) {
            return null;
        }
        InputStream is = null;
        is = resourcePath.startsWith("xmldb:") ? ((xmldbURL = new XmldbURL(resourcePath)).isEmbedded() ? new EmbeddedInputStream(xmldbURL) : new XmlrpcInputStream(xmldbURL)) : new URL(resourcePath).openStream();
        XMLInputSource xis = new XMLInputSource(xri.getPublicId(), resourcePath, baseSystemId, is, "UTF-8");
        if (LOG.isDebugEnabled()) {
            LOG.debug("XMLInputSource: " + this.getXisDetails(xis));
        }
        return xis;
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        return "PublicId='" + xrid.getPublicId() + "' BaseSystemId='" + xrid.getBaseSystemId() + "' ExpandedSystemId='" + xrid.getExpandedSystemId() + "' LiteralSystemId='" + xrid.getLiteralSystemId() + "' Namespace='" + xrid.getNamespace() + "' ";
    }

    private String getXisDetails(XMLInputSource xis) {
        return "PublicId='" + xis.getPublicId() + "' SystemId='" + xis.getSystemId() + "' BaseSystemId='" + xis.getBaseSystemId() + "' Encoding='" + xis.getEncoding() + "' ";
    }
}

