/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.validation.internal.DatabaseResources;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchResourceResolver
implements XMLEntityResolver {
    private static final Logger LOG = LogManager.getLogger(SearchResourceResolver.class);
    private String collection = null;
    private BrokerPool brokerPool = null;

    public SearchResourceResolver(String collectionPath, BrokerPool pool) {
        LOG.debug("Specified collectionPath=" + collectionPath);
        this.collection = collectionPath;
        this.brokerPool = pool;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri));
        }
        String resourcePath = null;
        DatabaseResources databaseResources = new DatabaseResources(this.brokerPool);
        Subject user = this.brokerPool.getSecurityManager().getGuestSubject();
        if (xri.getNamespace() != null) {
            LOG.debug("Searching namespace '" + xri.getNamespace() + "' in database from " + this.collection + "...");
            resourcePath = databaseResources.findXSD(this.collection, xri.getNamespace(), user);
        } else if (xri.getPublicId() != null) {
            LOG.debug("Searching publicId '" + xri.getPublicId() + "' in catalogs in database from " + this.collection + "...");
            String catalogPath = databaseResources.findCatalogWithDTD(this.collection, xri.getPublicId(), user);
            LOG.debug("Found publicId in catalog '" + catalogPath + "'");
            if (catalogPath != null && catalogPath.startsWith("/")) {
                catalogPath = "xmldb:exist://" + catalogPath;
            }
            eXistXMLCatalogResolver resolver = new eXistXMLCatalogResolver();
            resolver.setCatalogList(new String[]{catalogPath});
            try {
                InputSource source = resolver.resolveEntity(xri.getPublicId(), "");
                if (source != null) {
                    resourcePath = source.getSystemId();
                }
            }
            catch (IOException | SAXException ex) {
                LOG.debug((Object)ex);
            }
        } else {
            return null;
        }
        if (resourcePath == null) {
            LOG.debug("resourcePath=null");
            return null;
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = "xmldb:exist://" + resourcePath;
        }
        LOG.debug("resourcePath='" + resourcePath + "'");
        InputStream is = new URL(resourcePath).openStream();
        XMLInputSource xis = new XMLInputSource(xri.getPublicId(), xri.getExpandedSystemId(), xri.getBaseSystemId(), is, "UTF-8");
        if (LOG.isDebugEnabled()) {
            LOG.debug("XMLInputSource: " + this.getXisDetails(xis));
        }
        return xis;
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        return String.format("PublicId='%s' BaseSystemId='%s' ExpandedSystemId='%s' LiteralSystemId='%s' Namespace='%s' ", xrid.getPublicId(), xrid.getBaseSystemId(), xrid.getExpandedSystemId(), xrid.getLiteralSystemId(), xrid.getNamespace());
    }

    private String getXisDetails(XMLInputSource xis) {
        return String.format("PublicId='%s' SystemId='%s' BaseSystemId='%s' Encoding='%s' ", xis.getPublicId(), xis.getSystemId(), xis.getBaseSystemId(), xis.getEncoding());
    }
}

