/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.util.FileUtils;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class eXistXMLCatalogResolver
extends XMLCatalogResolver {
    private static final Logger LOG = LogManager.getLogger(eXistXMLCatalogResolver.class);

    public eXistXMLCatalogResolver() {
        LOG.debug("Initializing");
    }

    public eXistXMLCatalogResolver(String[] catalogs) {
        super(catalogs);
        LOG.debug("Initializing using catalogs");
    }

    eXistXMLCatalogResolver(String[] catalogs, boolean preferPublic) {
        super(catalogs, preferPublic);
        LOG.debug("Initializing using catalogs, preferPublic=" + preferPublic);
    }

    public void setCatalogs(List<String> catalogs) {
        if (catalogs != null && catalogs.size() > 0) {
            String[] allCatalogs = new String[catalogs.size()];
            int counter = 0;
            Iterator<String> iterator = catalogs.iterator();
            while (iterator.hasNext()) {
                String element;
                allCatalogs[counter] = element = iterator.next();
                ++counter;
            }
            super.setCatalogList(allCatalogs);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("Resolving publicId='" + publicId + "', systemId='" + systemId + "'");
        InputSource retValue = super.resolveEntity(publicId, systemId);
        if (retValue == null) {
            retValue = this.resolveEntityFallback(publicId, systemId);
        }
        LOG.debug("Resolved " + (retValue != null));
        if (retValue != null) {
            LOG.debug("PublicId='" + retValue.getPublicId() + "' SystemId=" + retValue.getSystemId());
        }
        return retValue;
    }

    private InputSource resolveEntityFallback(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("Resolve failed, fallback scenario");
        if (publicId != null) {
            return null;
        }
        URL url = new URL(systemId);
        if ("file".equals(url.getProtocol())) {
            String path = url.getPath();
            Path f = Paths.get(path, new String[0]).normalize();
            if (!Files.isReadable(f)) {
                return this.resolveEntity(null, FileUtils.fileName(f));
            }
            return new InputSource(f.toAbsolutePath().toString());
        }
        return new InputSource(url.openStream());
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOG.debug("Resolving type='" + type + "', namespaceURI='" + namespaceURI + "', publicId='" + publicId + "', systemId='" + systemId + "', baseURI='" + baseURI + "'");
        LSInput retValue = super.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
        LOG.debug("Resolved " + (retValue != null));
        if (retValue != null) {
            LOG.debug("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "' BaseURI='" + retValue.getBaseURI() + "'");
        }
        return retValue;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        LOG.debug("Resolving name='" + name + "', publicId='" + publicId + "', baseURI='" + baseURI + "', systemId='" + systemId + "'");
        InputSource retValue = super.resolveEntity(name, publicId, baseURI, systemId);
        LOG.debug("Resolved " + (retValue != null));
        if (retValue != null) {
            LOG.debug("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "'");
        }
        return retValue;
    }

    public String resolveIdentifier(XMLResourceIdentifier xri) throws IOException, XNIException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri));
        }
        String retValue = super.resolveIdentifier(xri);
        LOG.debug("Resolved " + (retValue != null));
        if (retValue != null) {
            LOG.debug("Identifier='" + retValue + "'");
        }
        return retValue;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri));
        }
        XMLInputSource retValue = super.resolveEntity(xri);
        LOG.debug("Resolved " + (retValue != null));
        if (retValue != null) {
            LOG.debug("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "' BaseSystemId=" + retValue.getBaseSystemId());
        }
        return retValue;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        LOG.debug("name='" + name + "' baseURI='" + baseURI + "'");
        return super.getExternalSubset(name, baseURI);
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        return "PublicId='" + xrid.getPublicId() + "' BaseSystemId='" + xrid.getBaseSystemId() + "' ExpandedSystemId='" + xrid.getExpandedSystemId() + "' LiteralSystemId='" + xrid.getLiteralSystemId() + "' Namespace='" + xrid.getNamespace() + "' ";
    }
}

