/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver.unstable;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcInputStream;
import org.exist.validation.resolver.unstable.eXistLSInput;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class eXistLSResourceResolver
implements LSResourceResolver {
    private static final Logger LOG = LogManager.getLogger(eXistLSResourceResolver.class);

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOG.debug("type=" + type + " namespaceURI=" + namespaceURI + " publicId=" + publicId + " systemId=" + systemId + " baseURI=" + baseURI);
        eXistLSInput lsInput = new eXistLSInput();
        try {
            InputStream is = this.getInputStream(systemId);
            lsInput.setByteStream(is);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            lsInput = null;
        }
        return lsInput;
    }

    private InputStream getInputStream(String resourcePath) throws MalformedURLException, IOException {
        XmldbURL xmldbURL;
        if (resourcePath.startsWith("/db")) {
            resourcePath = "xmldb:exist://" + resourcePath;
        }
        InputStream is = null;
        is = resourcePath.startsWith("xmldb:") ? ((xmldbURL = new XmldbURL(resourcePath)).isEmbedded() ? new EmbeddedInputStream(xmldbURL) : new XmlrpcInputStream(xmldbURL)) : new URL(resourcePath).openStream();
        return is;
    }
}

