/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exist.security.ACLPermission;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.aider.ACEAider;
import org.exist.security.internal.aider.PermissionAider;
import org.exist.security.internal.aider.PermissionAiderFactory;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;

public abstract class AbstractRemote {
    protected RemoteCollection collection;

    AbstractRemote(RemoteCollection collection) {
        this.collection = collection;
    }

    protected XmldbURI resolve(XmldbURI name) {
        if (this.collection != null) {
            return this.collection.getPathURI().resolveCollectionPath(name);
        }
        return name;
    }

    protected Stream<ACEAider> extractAces(Object aclParameter) {
        return Optional.ofNullable((Object[])aclParameter).map(Arrays::stream).map(stream -> stream.map(o -> (ACEAider)o)).orElse(Stream.empty());
    }

    protected Permission getPermission(String owner, String group, int mode, Stream<ACEAider> aces) throws PermissionDeniedException {
        PermissionAider perm = PermissionAiderFactory.getPermission(owner, group, mode);
        if (perm instanceof ACLPermission) {
            ACLPermission aclPermission = (ACLPermission)((Object)perm);
            for (ACEAider ace : aces.collect(Collectors.toList())) {
                aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
            }
        }
        return perm;
    }
}

