/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.EXistInputSource;
import org.exist.util.FileUtils;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.BinaryValue;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;

public class LocalBinaryResource
extends AbstractEXistResource
implements ExtendedResource,
BinaryResource,
EXistResource {
    protected InputSource inputSource = null;
    protected Path file = null;
    protected byte[] rawData = null;
    private BinaryValue binaryValue = null;
    private boolean isExternal = false;

    public LocalBinaryResource(Subject user, BrokerPool brokerPool, LocalCollection collection, XmldbURI docId) {
        super(user, brokerPool, collection, docId, null);
    }

    public String getResourceType() throws XMLDBException {
        return "BinaryResource";
    }

    @Override
    public Object getExtendedContent() throws XMLDBException {
        if (this.file != null) {
            return this.file;
        }
        if (this.inputSource != null) {
            return this.inputSource;
        }
        if (this.rawData != null) {
            return this.rawData;
        }
        if (this.binaryValue != null) {
            return this.binaryValue;
        }
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> broker.getBinaryResource((BinaryDocument)document));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent() throws XMLDBException {
        Object res = this.getExtendedContent();
        if (res == null) return res;
        if (res instanceof Path) {
            return this.readFile((Path)res);
        }
        if (res instanceof File) {
            return this.readFile(((File)res).toPath());
        }
        if (res instanceof InputSource) {
            return this.readFile((InputSource)res);
        }
        if (res instanceof byte[]) {
            return res;
        }
        if (res instanceof BinaryValue) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ((BinaryValue)res).streamBinaryTo((OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
        }
        if (!(res instanceof InputStream)) return res;
        try (InputStream is = (InputStream)res;){
            byte[] byArray = this.readFile(is);
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof Path) {
            this.file = (Path)value;
        } else if (value instanceof File) {
            this.file = ((File)value).toPath();
        } else if (value instanceof InputSource) {
            this.inputSource = (InputSource)value;
        } else if (value instanceof byte[]) {
            this.rawData = (byte[])value;
        } else if (value instanceof String) {
            this.rawData = ((String)value).getBytes();
        } else if (value instanceof BinaryValue) {
            this.binaryValue = (BinaryValue)value;
        } else {
            throw new XMLDBException(1, "don't know how to handle value of type " + value.getClass().getName());
        }
        this.isExternal = true;
    }

    @Override
    public InputStream getStreamContent() throws XMLDBException {
        InputStream is;
        if (this.file != null) {
            try {
                is = Files.newInputStream(this.file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
        } else {
            is = this.inputSource != null ? this.inputSource.getByteStream() : (this.rawData != null ? new ByteArrayInputStream(this.rawData) : (this.binaryValue != null ? this.binaryValue.getInputStream() : this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> broker.getBinaryResource((BinaryDocument)document))));
        }
        return is;
    }

    @Override
    public void getContentIntoAFile(Path tmpFile) throws XMLDBException {
        try (OutputStream bos = Files.newOutputStream(tmpFile, new OpenOption[0]);){
            this.getContentIntoAStream(bos);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, "error while loading binary resource " + this.getId(), (Throwable)ioe);
        }
    }

    @Override
    public void getContentIntoAStream(OutputStream os) throws XMLDBException {
        this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> {
            if (os instanceof FileOutputStream) {
                try (BufferedOutputStream bos = new BufferedOutputStream(os, 65536);){
                    broker.readBinaryResource((BinaryDocument)document, bos);
                }
            } else {
                broker.readBinaryResource((BinaryDocument)document, os);
            }
            return null;
        });
    }

    @Override
    public void freeResources() throws XMLDBException {
        if (!this.isExternal && this.file != null) {
            this.file = null;
        }
        if (this.binaryValue != null) {
            try {
                this.binaryValue.close();
            }
            catch (IOException e) {
                throw new XMLDBException(1, "error while closing binary resource " + this.getId(), (Throwable)e);
            }
        }
    }

    @Override
    public long getStreamLength() throws XMLDBException {
        long retval;
        block21: {
            if (this.file != null) {
                retval = FileUtils.sizeQuietly(this.file);
            } else if (this.inputSource != null && this.inputSource instanceof EXistInputSource) {
                retval = ((EXistInputSource)this.inputSource).getByteStreamLength();
            } else if (this.rawData != null) {
                retval = this.rawData.length;
            } else {
                if (this.binaryValue != null) {
                    try (CountingOutputStream os = new CountingOutputStream((OutputStream)new NullOutputStream());){
                        this.binaryValue.streamBinaryTo((OutputStream)os);
                        retval = os.getByteCount();
                        break block21;
                    }
                    catch (IOException e) {
                        throw new XMLDBException(1, "error while obtaining length of binary value " + this.getId(), (Throwable)e);
                    }
                }
                retval = this.getContentLength();
            }
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile(Path file) throws XMLDBException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Files.copy(file, (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(1, "file " + file.toAbsolutePath() + " could not be found", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile(InputSource inSrc) throws XMLDBException {
        try (InputStream is = inSrc.getByteStream();){
            byte[] byArray = this.readFile(is);
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Could not read InputSource", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile(InputStream is) throws XMLDBException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buf = new byte[2048];
            int read = -1;
            while ((read = is.read(buf)) > -1) {
                bos.write(buf, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XMLDBException(1, "IO exception while reading file " + this.file.toAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public DocumentType getDocType() throws XMLDBException {
        return null;
    }

    @Override
    public void setDocType(DocumentType doctype) throws XMLDBException {
    }

    @Override
    public void setLexicalHandler(LexicalHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    @Nullable
    public Properties getProperties() {
        return null;
    }
}

