/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.LockToken;
import org.exist.security.Account;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.Txn;
import org.exist.util.HtmlToXmlParser;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.AbstractLocal;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.LocalBinaryResource;
import org.exist.xmldb.LocalCollectionManagementService;
import org.exist.xmldb.LocalDatabaseInstanceManager;
import org.exist.xmldb.LocalIndexQueryService;
import org.exist.xmldb.LocalUserManagementService;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.LocalXPathQueryService;
import org.exist.xmldb.LocalXUpdateQueryService;
import org.exist.xmldb.XmldbURI;
import org.exist.xmldb.function.LocalXmldbCollectionFunction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class LocalCollection
extends AbstractLocal
implements EXistCollection {
    private static Logger LOG = LogManager.getLogger(LocalCollection.class);
    public static final String NORMALIZE_HTML = "normalize-html";
    private static final Properties defaultProperties = new Properties();
    private final XmldbURI path;
    private Properties properties = new Properties(defaultProperties);
    private boolean needsSync = false;
    private XMLReader userReader = null;

    public LocalCollection(Subject user, BrokerPool brokerPool, XmldbURI collection) throws XMLDBException {
        this(user, brokerPool, null, collection);
    }

    public LocalCollection(Subject user, BrokerPool brokerPool, LocalCollection parent, XmldbURI name) throws XMLDBException {
        super(user, brokerPool, parent);
        this.path = name == null ? XmldbURI.ROOT_COLLECTION_URI.toCollectionPathURI() : name.toCollectionPathURI();
        this.read(200).apply((collection, broker, transaction) -> null);
    }

    protected boolean checkOwner(Collection collection, Account account) throws XMLDBException {
        return account.equals(collection.getPermissions().getOwner());
    }

    protected boolean checkPermissions(Collection collection, int perm) throws XMLDBException {
        return collection.getPermissions().validate(this.user, perm);
    }

    public void close() throws XMLDBException {
        if (this.needsSync) {
            this.withDb((broker, transaction) -> {
                broker.sync(Sync.MAJOR);
                return null;
            });
        }
    }

    public String createId() throws XMLDBException {
        return (String)this.read().apply((collection, broker, transaction) -> {
            XmldbURI id;
            boolean ok;
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(broker, id)) {
                    ok = false;
                }
                if (!collection.hasChildCollection(broker, id)) continue;
                ok = false;
            } while (!ok);
            return id.toString();
        });
    }

    public Resource createResource(String id, String type) throws XMLDBException {
        AbstractEXistResource r;
        XmldbURI idURI;
        if (id == null) {
            id = this.createId();
        }
        try {
            idURI = XmldbURI.xmldbUriFor(id);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        switch (type) {
            case "XMLResource": {
                r = new LocalXMLResource(this.user, this.brokerPool, this, idURI);
                break;
            }
            case "BinaryResource": {
                r = new LocalBinaryResource(this.user, this.brokerPool, this, idURI);
                break;
            }
            default: {
                throw new XMLDBException(301, "Unknown resource type: " + type);
            }
        }
        ((AbstractEXistResource)r).isNewResource = true;
        return r;
    }

    public org.xmldb.api.base.Collection getChildCollection(String name) throws XMLDBException {
        XmldbURI childURI;
        try {
            childURI = XmldbURI.xmldbUriFor(name);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        XmldbURI nameUri = (XmldbURI)this.read().apply((collection, broker, transaction) -> {
            XmldbURI childName = null;
            if (collection.hasChildCollection(broker, childURI)) {
                childName = this.getPathURI().append(childURI);
            }
            return childName;
        });
        if (nameUri != null) {
            return new LocalCollection(this.user, this.brokerPool, this, nameUri);
        }
        return null;
    }

    public int getChildCollectionCount() throws XMLDBException {
        return (Integer)this.read().apply((collection, broker, transaction) -> {
            if (this.checkPermissions(collection, 4)) {
                return collection.getChildCollectionCount(broker);
            }
            return 0;
        });
    }

    public String getName() throws XMLDBException {
        return (String)this.read().apply((collection, broker, transaction) -> collection.getURI().toString());
    }

    public org.xmldb.api.base.Collection getParentCollection() throws XMLDBException {
        if (this.getName().equals("/db")) {
            return null;
        }
        if (this.collection == null) {
            XmldbURI parentUri = (XmldbURI)this.read().apply((collection, broker, transaction) -> collection.getParentURI());
            this.collection = new LocalCollection(this.user, this.brokerPool, null, parentUri);
        }
        return this.collection;
    }

    public String getPath() throws XMLDBException {
        return this.path.toString();
    }

    @Override
    public XmldbURI getPathURI() {
        return this.path;
    }

    public Resource getResource(String id) throws XMLDBException {
        XmldbURI idURI;
        try {
            idURI = XmldbURI.xmldbUriFor(id);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        return (Resource)this.read().apply((collection, broker, transaction) -> {
            AbstractEXistResource r;
            DocumentImpl document = collection.getDocument(broker, idURI);
            if (document == null) {
                LOG.warn("Resource " + idURI + " not found");
                return null;
            }
            switch (document.getResourceType()) {
                case 0: {
                    r = new LocalXMLResource(this.user, this.brokerPool, this, idURI);
                    break;
                }
                case 1: {
                    r = new LocalBinaryResource(this.user, this.brokerPool, this, idURI);
                    break;
                }
                default: {
                    throw new XMLDBException(301, "Unknown resource type");
                }
            }
            ((AbstractEXistResource)r).setMimeType(document.getMetadata().getMimeType());
            return r;
        });
    }

    public int getResourceCount() throws XMLDBException {
        return (Integer)this.read().apply((collection, broker, transaction) -> {
            if (this.checkPermissions(collection, 4)) {
                return collection.getDocumentCount(broker);
            }
            return 0;
        });
    }

    public Service getService(String name, String version) throws XMLDBException {
        AbstractLocalService service;
        switch (name) {
            case "XPathQueryService": 
            case "XQueryService": {
                service = new LocalXPathQueryService(this.user, this.brokerPool, this);
                break;
            }
            case "CollectionManagementService": 
            case "CollectionManager": {
                service = new LocalCollectionManagementService(this.user, this.brokerPool, this);
                break;
            }
            case "UserManagementService": {
                service = new LocalUserManagementService(this.user, this.brokerPool, this);
                break;
            }
            case "DatabaseInstanceManager": {
                service = new LocalDatabaseInstanceManager(this.user, this.brokerPool);
                break;
            }
            case "XUpdateQueryService": {
                service = new LocalXUpdateQueryService(this.user, this.brokerPool, this);
                break;
            }
            case "IndexQueryService": {
                service = new LocalIndexQueryService(this.user, this.brokerPool, this);
                break;
            }
            default: {
                throw new XMLDBException(100);
            }
        }
        return service;
    }

    public Service[] getServices() throws XMLDBException {
        Service[] services = new Service[]{new LocalXPathQueryService(this.user, this.brokerPool, this), new LocalCollectionManagementService(this.user, this.brokerPool, this), new LocalUserManagementService(this.user, this.brokerPool, this), new LocalDatabaseInstanceManager(this.user, this.brokerPool), new LocalXUpdateQueryService(this.user, this.brokerPool, this), new LocalIndexQueryService(this.user, this.brokerPool, this)};
        return services;
    }

    public boolean isOpen() throws XMLDBException {
        return true;
    }

    public String[] listChildCollections() throws XMLDBException {
        return (String[])this.read().apply((collection, broker, transaction) -> {
            String[] collections = new String[collection.getChildCollectionCount(broker)];
            int j = 0;
            Iterator<XmldbURI> i = collection.collectionIterator(broker);
            while (i.hasNext()) {
                collections[j] = i.next().toString();
                ++j;
            }
            return collections;
        });
    }

    @Override
    public String[] getChildCollections() throws XMLDBException {
        return this.listChildCollections();
    }

    public String[] listResources() throws XMLDBException {
        return (String[])this.read().apply((collection, broker, transaction) -> {
            ArrayList<XmldbURI> allresources = new ArrayList<XmldbURI>();
            Iterator<DocumentImpl> i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                LockToken lock = doc.getMetadata().getLockToken();
                if (lock != null && lock.isNullResource()) continue;
                allresources.add(doc.getFileURI());
            }
            int j = 0;
            String[] resources = new String[allresources.size()];
            Iterator i2 = allresources.iterator();
            while (i2.hasNext()) {
                resources[j] = ((XmldbURI)i2.next()).toString();
                ++j;
            }
            return resources;
        });
    }

    @Override
    public String[] getResources() throws XMLDBException {
        return this.listResources();
    }

    public void registerService(Service serv) throws XMLDBException {
        throw new XMLDBException(2);
    }

    public void removeResource(Resource res) throws XMLDBException {
        XmldbURI resURI;
        if (res == null) {
            return;
        }
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        this.modify().apply((collection, broker, transaction) -> {
            DocumentImpl doc = collection.getDocument(broker, resURI);
            if (doc == null) {
                throw new XMLDBException(301, "Resource " + resURI + " not found");
            }
            if ("XMLResource".equals(res.getResourceType())) {
                collection.removeXMLResource(transaction, broker, resURI);
            } else {
                collection.removeBinaryResource(transaction, broker, resURI);
            }
            return null;
        });
        this.needsSync = true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) throws XMLDBException {
        return this.properties.getProperty(property);
    }

    public String getProperty(String property, String defaultValue) throws XMLDBException {
        return this.properties.getProperty(property, defaultValue);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.properties.setProperty(property, value);
    }

    public void storeResource(Resource resource) throws XMLDBException {
        this.storeResource(resource, null, null);
    }

    @Override
    public void storeResource(Resource resource, Date a, Date b) throws XMLDBException {
        if (resource.getResourceType().equals("XMLResource")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("storing document " + resource.getId());
            }
            ((LocalXMLResource)resource).datecreated = a;
            ((LocalXMLResource)resource).datemodified = b;
            this.storeXMLResource((LocalXMLResource)resource);
        } else if (resource.getResourceType().equals("BinaryResource")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("storing binary resource " + resource.getId());
            }
            ((LocalBinaryResource)resource).datecreated = a;
            ((LocalBinaryResource)resource).datemodified = b;
            this.storeBinaryResource((LocalBinaryResource)resource);
        } else {
            throw new XMLDBException(302, "unknown resource type: " + resource.getResourceType());
        }
        ((AbstractEXistResource)resource).isNewResource = false;
        this.needsSync = true;
    }

    private void storeBinaryResource(LocalBinaryResource res) throws XMLDBException {
        XmldbURI resURI;
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        this.modify().apply((collection, broker, transaction) -> {
            block15: {
                try {
                    long conLength = res.getStreamLength();
                    if (conLength != -1L) {
                        try (InputStream is = res.getStreamContent();){
                            collection.addBinaryResource(transaction, broker, resURI, is, res.getMimeType(), conLength, res.datecreated, res.datemodified);
                            break block15;
                        }
                    }
                    collection.addBinaryResource(transaction, broker, resURI, (byte[])res.getContent(), res.getMimeType(), res.datecreated, res.datemodified);
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
            }
            return null;
        });
    }

    private void storeXMLResource(LocalXMLResource res) throws XMLDBException {
        XmldbURI resURI;
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        this.modify().apply((collection, broker, transaction) -> {
            String uri = null;
            if (res.file != null) {
                uri = res.file.toUri().toASCIIString();
            }
            try {
                IndexInfo info;
                if (uri != null || res.inputSource != null) {
                    this.setupParser(collection, res);
                    info = collection.validateXMLResource(transaction, broker, resURI, uri != null ? new InputSource(uri) : res.inputSource);
                } else {
                    info = res.root != null ? collection.validateXMLResource(transaction, broker, resURI, res.root) : collection.validateXMLResource(transaction, broker, resURI, res.content);
                }
                info.getDocument().getMetadata().setMimeType(res.getMimeType());
                if (res.datecreated != null) {
                    info.getDocument().getMetadata().setCreated(res.datecreated.getTime());
                }
                if (res.datemodified != null) {
                    info.getDocument().getMetadata().setLastModified(res.datemodified.getTime());
                }
                if (uri != null || res.inputSource != null) {
                    collection.store(transaction, broker, info, uri != null ? new InputSource(uri) : res.inputSource);
                } else if (res.root != null) {
                    collection.store(transaction, broker, info, res.root);
                } else {
                    collection.store(transaction, broker, info, res.content);
                }
                return null;
            }
            catch (EXistException | SAXException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
        });
    }

    private void setupParser(Collection collection, LocalXMLResource res) throws XMLDBException {
        String normalize = this.properties.getProperty(NORMALIZE_HTML, "no");
        if ((normalize.equalsIgnoreCase("yes") || normalize.equalsIgnoreCase("true")) && ("text/html".equals(res.getMimeType()) || res.getId().endsWith(".htm") || res.getId().endsWith(".html"))) {
            Optional<Either<Throwable, XMLReader>> maybeReaderInst = HtmlToXmlParser.getHtmlToXmlParser(this.brokerPool.getConfiguration());
            if (maybeReaderInst.isPresent()) {
                Either<Throwable, XMLReader> readerInst = maybeReaderInst.get();
                if (readerInst.isLeft()) {
                    String msg = "Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath";
                    Throwable t = (Throwable)readerInst.left().get();
                    LOG.error("Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath", t);
                    throw new XMLDBException(1, "Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath", t);
                }
                XMLReader htmlReader = (XMLReader)readerInst.right().get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Converting HTML to XML using: " + htmlReader.getClass().getName());
                }
                collection.setReader(htmlReader);
            } else {
                throw new XMLDBException(1, "There is no HTML to XML parser configured in conf.xml");
            }
        }
    }

    @Override
    public Date getCreationTime() throws XMLDBException {
        return (Date)this.read().apply((collection, broker, transaction) -> new Date(collection.getCreationTime()));
    }

    @Override
    public boolean isRemoteCollection() throws XMLDBException {
        return false;
    }

    public XmldbURI getURI() {
        StringBuilder accessor = new StringBuilder("xmldb:");
        accessor.append("exist");
        accessor.append("://");
        accessor.append("");
        try {
            return XmldbURI.create(accessor.toString(), this.getPath());
        }
        catch (XMLDBException e) {
            return null;
        }
    }

    @Override
    public void setTriggersEnabled(boolean triggersEnabled) throws XMLDBException {
        this.modify().apply((collection, broker, transaction) -> {
            collection.setTriggersEnabled(triggersEnabled);
            return null;
        });
    }

    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read() throws XMLDBException {
        return readOp -> this.read(this.path).apply((collection, broker, transaction) -> {
            collection.setReader(this.userReader);
            return readOp.apply(collection, broker, transaction);
        });
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(int errorCode) throws XMLDBException {
        return readOp -> this.read(this.path, errorCode).apply((collection, broker, transaction) -> {
            collection.setReader(this.userReader);
            return readOp.apply(collection, broker, transaction);
        });
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> read(DBBroker broker, Txn transaction) throws XMLDBException {
        return readOp -> this.read(broker, transaction, this.path).apply((collection, broker1, transaction1) -> {
            collection.setReader(this.userReader);
            return readOp.apply(collection, broker1, transaction1);
        });
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> modify() throws XMLDBException {
        return modifyOp -> this.modify(this.path).apply((collection, broker, transaction) -> {
            collection.setReader(this.userReader);
            return modifyOp.apply(collection, broker, transaction);
        });
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> modify(DBBroker broker, Txn transaction) throws XMLDBException {
        return modifyOp -> this.modify(broker, transaction, this.path).apply((collection, broker1, transaction1) -> {
            collection.setReader(this.userReader);
            return modifyOp.apply(collection, broker1, transaction1);
        });
    }

    protected <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> with(Lock.LockMode lockMode, DBBroker broker, Txn transaction) throws XMLDBException {
        return op -> this.with(lockMode, broker, transaction, this.path).apply((collection, broker1, transaction1) -> {
            collection.setReader(this.userReader);
            return op.apply(collection, broker1, transaction1);
        });
    }

    static {
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("process-xsl-pi", "no");
        defaultProperties.setProperty(NORMALIZE_HTML, "no");
    }
}

