/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import java.util.Date;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.plugin.command.Commands;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.XMLDBException;

public class LocalCollectionManagementService
extends AbstractLocalService
implements EXistCollectionManagementService {
    public LocalCollectionManagementService(Subject user, BrokerPool pool, LocalCollection parent) {
        super(user, pool, parent);
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public org.xmldb.api.base.Collection createCollection(String collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    @Override
    public org.xmldb.api.base.Collection createCollection(XmldbURI collName) throws XMLDBException {
        return this.createCollection(collName, null);
    }

    @Override
    public org.xmldb.api.base.Collection createCollection(String collName, Date created) throws XMLDBException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(collName), created);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public org.xmldb.api.base.Collection createCollection(XmldbURI name, Date created) throws XMLDBException {
        XmldbURI collName = this.resolve(name);
        this.withDb((broker, transaction) -> {
            try {
                Collection coll = broker.getOrCreateCollection(transaction, collName);
                if (created != null) {
                    coll.setCreationTime(created.getTime());
                }
                broker.saveCollection(transaction, coll);
                return null;
            }
            catch (TriggerException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
        });
        return new LocalCollection(this.user, this.brokerPool, this.collection, collName);
    }

    public String getProperty(String property) {
        return null;
    }

    @Override
    public void removeCollection(String collName) throws XMLDBException {
        try {
            this.removeCollection(XmldbURI.xmldbUriFor(collName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void removeCollection(XmldbURI name) throws XMLDBException {
        XmldbURI collName = this.resolve(name);
        this.modify(collName).apply((collection, broker, transaction) -> broker.removeCollection(transaction, collection));
    }

    @Override
    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.move(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void move(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        this.withDb((broker, transaction) -> this.modify(broker, transaction, srcPath).apply((source, b1, t1) -> this.modify(b1, t1, destPath).apply((destination, b2, t2) -> {
            b2.moveCollection(t2, source, destination, newName);
            return null;
        })));
    }

    @Override
    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.moveResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void moveResource(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        this.withDb((broker, transaction) -> this.modify(broker, transaction, srcPath.removeLastSegment()).apply((sourceCol, b1, t1) -> {
            DocumentImpl source = sourceCol.getDocument(b1, srcPath.lastSegment());
            if (source == null) {
                throw new XMLDBException(300, "Resource " + srcPath + " not found");
            }
            return this.modify(b1, t1, destPath).apply((destinationCol, b2, t2) -> {
                b2.moveResource(t2, source, destinationCol, newName);
                return null;
            });
        }));
    }

    @Override
    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copy(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void copy(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        this.withDb((broker, transaction) -> this.read(broker, transaction, srcPath).apply((source, b1, t1) -> this.modify(b1, t1, destPath).apply((destination, b2, t2) -> {
            try {
                b2.copyCollection(t2, source, destination, newName);
                return null;
            }
            catch (EXistException e) {
                throw new XMLDBException(1, "failed to move collection " + srcPath, (Throwable)e);
            }
        })));
    }

    @Override
    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copyResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void copyResource(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        this.withDb((broker, transaction) -> this.read(broker, transaction, srcPath.removeLastSegment()).apply((sourceCol, b1, t1) -> {
            DocumentImpl source = sourceCol.getDocument(b1, srcPath.lastSegment());
            if (source == null) {
                throw new XMLDBException(300, "Resource " + srcPath + " not found");
            }
            return this.modify(b1, t1, destPath).apply((destinationCol, b2, t2) -> {
                try {
                    b2.copyResource(t2, source, destinationCol, newName);
                    return null;
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, "failed to copy resource " + srcPath, (Throwable)e);
                }
            });
        }));
    }

    public void setProperty(String property, String value) {
    }

    @Override
    public void runCommand(String[] params) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            Commands.command(XmldbURI.create(this.collection.getPath()), params);
            return null;
        });
    }
}

